/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.service;


import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yifu.cloud.plus.v1.yifu.archives.entity.FddSealInfo;
import com.yifu.cloud.plus.v1.yifu.archives.entity.FddSealPersonAuth;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;

import java.util.List;

/**
 * 法大大印章授权表
 *
 * @author huyc
 * @date 2022-06-28 16:24:12
 */
public interface FddSealPersonAuthService extends IService<FddSealPersonAuth> {

	/**
	 * 法大大印章授权表简单分页查询
	 * @param fddSealPersonAuth 法大大印章授权表
	 * @return
	 */
	IPage<FddSealPersonAuth> getFddSealPersonAuthPage(Page<FddSealPersonAuth> page, FddSealPersonAuth fddSealPersonAuth);

	/**
	 * 通过员工id获得所拥有的印章权限
	 * @param personAccountId 客服id
	 * @return
	 */
	R<List<FddSealInfo>> getSealId(String personAccountId);
}
