/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TElecEmployeeInfo;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import org.springframework.web.multipart.MultipartFile;

/**
 * 电子档案信息表
 *
 * @author fxj
 * @date 2022-06-18 09:39:46
 */
public interface TElecEmployeeInfoService extends IService<TElecEmployeeInfo> {

	IPage<TElecEmployeeInfo> getTElecEmployeeInfoPage(Page page, TElecEmployeeInfo vo);

	/**
	 * @description: 解析zip文件包中的多个附件，并生成结算记录
	 * @param file zip文件包
	 * @return: R
	 * @author: huyc
	 * @date: 2022/6/24
	 */
	R importZip(MultipartFile file);

	/**
	 * @description: 通过身份证号查询人员档案
	 * @param idCard 身份证号
	 * @return: R
	 * @author: huyc
	 * @date: 2022/6/27
	 */
	R getEmpInfoByCard(String idCard);

	R saveElecInfo(TElecEmployeeInfo tElecEmployeeInfo);

}
