/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.archives.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yifu.cloud.plus.v1.yifu.archives.entity.FddSealInfo;
import com.yifu.cloud.plus.v1.yifu.archives.entity.FddSealPersonAuth;
import com.yifu.cloud.plus.v1.yifu.archives.mapper.FddSealInfoMapper;
import com.yifu.cloud.plus.v1.yifu.archives.mapper.FddSealPersonAuthMapper;
import com.yifu.cloud.plus.v1.yifu.archives.service.FddSealPersonAuthService;
import com.yifu.cloud.plus.v1.yifu.common.core.util.Common;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 法大大印章授权表
 *
 * @author huyc
 * @date 2022-06-28 16:24:12
 */
@Service
@RequiredArgsConstructor
public class FddSealPersonAuthServiceImpl extends ServiceImpl<FddSealPersonAuthMapper, FddSealPersonAuth> implements FddSealPersonAuthService {

	private final FddSealInfoMapper fddSealInfoMapper;

	/**
	 * 法大大印章授权表简单分页查询
	 * @param fddSealPersonAuth 法大大印章授权表
	 * @return
	 */
	@Override
	public IPage<FddSealPersonAuth> getFddSealPersonAuthPage(Page<FddSealPersonAuth> page, FddSealPersonAuth fddSealPersonAuth){
		return baseMapper.getFddSealPersonAuthPage(page,fddSealPersonAuth);
	}

	@Override
	public R<List<FddSealInfo>> getSealId(String personAccountId) {
		List<FddSealPersonAuth> fddSealList = this.list(Wrappers.<FddSealPersonAuth>query().lambda()
				.eq(FddSealPersonAuth::getFddPersonAccountId, personAccountId));
		if (Common.isNotEmpty(fddSealList)) {
			List<String> sealIdList = fddSealList.stream().map(FddSealPersonAuth::getSealId).collect(Collectors.toList());
			List<FddSealInfo> fddSealInfoList = fddSealInfoMapper.selectList(Wrappers.<FddSealInfo>query().lambda().in(FddSealInfo::getSealId, sealIdList));
			return new R<>(fddSealInfoList);
		}
		List<FddSealInfo> listR = new ArrayList<>();
		return new R<>(listR);
	}
}
