package com.yifu.cloud.plus.v1.yifu.archives.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yifu.cloud.plus.v1.yifu.admin.api.entity.SysUser;
import com.yifu.cloud.plus.v1.yifu.archives.entity.MSetttleCustomerUser;
import com.yifu.cloud.plus.v1.yifu.archives.mapper.MSetttleCustomerUserMapper;
import com.yifu.cloud.plus.v1.yifu.archives.service.MSetttleCustomerUserService;
import com.yifu.cloud.plus.v1.yifu.archives.vo.MSetttleCustomerUserVo;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.CommonConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.util.Common;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.YifuUser;
import com.yifu.cloud.plus.v1.yifu.common.security.util.SecurityUtils;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Author fxj
 * @Description b端用户客户关系表
 * @Date 16:33 2022/12/27
 * @Param
 * @return
**/
@Service
public class MSetttleCustomerUserServiceImpl extends ServiceImpl<MSetttleCustomerUserMapper, MSetttleCustomerUser> implements MSetttleCustomerUserService {

    /**
     * b端用户客户关系表简单分页查询
     *
     * @param mSetttleCustomerUser b端用户客户关系表
     * @return
     */
    @Override
    public IPage<MSetttleCustomerUser> getMSetttleCustomerUserPage(Page<MSetttleCustomerUser> page, MSetttleCustomerUser mSetttleCustomerUser) {
        return baseMapper.getMSetttleCustomerUserPage(page, mSetttleCustomerUser);
    }

    @Override
    public Map<String, String> getCustomerUser(List<String> userIdList) {
        Map<String,String> map = new HashMap<>();
        List<MSetttleCustomerUserVo> list = baseMapper.getCustomerUser(userIdList);
        if(Common.isNotNull(list)){
            for(MSetttleCustomerUserVo vo :list){
                map.put(vo.getUserId(),vo.getCustomerName());
            }
        }
        return map;
    }

    @Override
    public Integer getCustomerCount() {
        return baseMapper.getCustomerCount();
    }

	@Override
	public List<String> getSettlePermissionForB(String userId) {
		if (Common.isNotNull(userId)){
			return baseMapper.getSettlePermissionForB(userId);
		}
		return null;
	}
}
