/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.archives.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TAutoRuleLog;
import com.yifu.cloud.plus.v1.yifu.archives.mapper.TAutoRuleLogMapper;
import com.yifu.cloud.plus.v1.yifu.archives.service.TAutoRuleLogService;
import com.yifu.cloud.plus.v1.yifu.archives.vo.TAutoRuleLogSearchVo;
import com.yifu.cloud.plus.v1.yifu.common.core.util.Common;
import com.yifu.cloud.plus.v1.yifu.common.core.util.equator.HrEquator;
import lombok.extern.log4j.Log4j2;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;

import static com.alibaba.fastjson.serializer.SerializerFeature.*;

/**
 * 规则变更日志表
 *
 * @author fxj
 * @date 2025-03-13 15:15:26
 */
@Log4j2
@Service
public class TAutoRuleLogServiceImpl extends ServiceImpl<TAutoRuleLogMapper, TAutoRuleLog> implements TAutoRuleLogService {
    /**
     * 规则变更日志表简单分页查询
     * @param tAutoRuleLog 规则变更日志表
     * @return
     */
    @Override
    public IPage<TAutoRuleLog> getTAutoRuleLogPage(Page<TAutoRuleLog> page, TAutoRuleLogSearchVo tAutoRuleLog){
        return baseMapper.getTAutoRuleLogPage(page,tAutoRuleLog);
    }

	@Override
	public <T> TAutoRuleLog saveModificationRecord(Integer type, String mainId, T oldInfo, T newInfo) {
		try{
			//比较记录不影响业务逻辑，用try套住
			//比较差异
			String differenceKey = HrEquator.comparisonValue(oldInfo, newInfo);
			//如果有差异保存差异
			if(!Common.isEmpty(differenceKey)){
				TAutoRuleLog log = new TAutoRuleLog();
				log.setType(type);
				log.setMainId(mainId);
				log.setCreateTime(LocalDateTime.now());
				log.setOldInfo(JSON.toJSONString(oldInfo,features));
				log.setNewInfo(JSON.toJSONString(newInfo,features));
				log.setDifferenceInfo(differenceKey);
				baseMapper.insert(log);
				return log;
			}
		}catch (Exception e){
			log.error(JSON.toJSON(oldInfo)+"插入修改记录报错>>>",e);
		}
		return null;
	}
	private SerializerFeature[] features = new SerializerFeature[] {
			WriteMapNullValue, WriteNullNumberAsZero, WriteNullListAsEmpty,
			WriteNullStringAsEmpty,WriteDateUseDateFormat
	};
}
