/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.archives.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TGzEmpSkill;
import com.yifu.cloud.plus.v1.yifu.archives.mapper.TGzEmpSkillMapper;
import com.yifu.cloud.plus.v1.yifu.archives.service.TGzEmpSkillService;
import lombok.RequiredArgsConstructor;
import lombok.extern.log4j.Log4j2;
import org.springframework.stereotype.Service;
import com.yifu.cloud.plus.v1.yifu.common.core.util.ErrorMessage;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.archives.vo.TGzEmpSkillSearchVo;

import javax.servlet.http.HttpServletResponse;
import java.io.InputStream;
import java.util.List;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ArrayUtil;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.read.listener.ReadListener;
import com.alibaba.excel.read.metadata.holder.ReadRowHolder;
import com.alibaba.excel.util.ListUtils;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.CommonConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.util.*;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;

import javax.servlet.ServletOutputStream;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.ArrayList;

/**
 * 瓜子技能证书
 *
 * @author chenyx
 * @date 2025-06-13 15:19:03
 */
@Log4j2
@Service
@RequiredArgsConstructor
public class TGzEmpSkillServiceImpl extends ServiceImpl<TGzEmpSkillMapper, TGzEmpSkill> implements TGzEmpSkillService {
	/**
	 * 瓜子技能证书简单分页查询
	 *
	 * @param tGzEmpSkill 瓜子技能证书
	 * @return
	 */
	@Override
	public IPage<TGzEmpSkill> getTGzEmpSkillPage(Page<TGzEmpSkill> page, TGzEmpSkillSearchVo tGzEmpSkill) {
		return baseMapper.getTGzEmpSkillPage(page, tGzEmpSkill);
	}


	@Override
	public List<TGzEmpSkill> noPageDiy(TGzEmpSkillSearchVo searchVo) {
		LambdaQueryWrapper<TGzEmpSkill> wrapper = buildQueryWrapper(searchVo);
		List<String> idList = Common.getList(searchVo.getIds());
		if (Common.isNotNull(idList)) {
			wrapper.in(TGzEmpSkill::getId, idList);
		}

		wrapper.orderByDesc(BaseEntity::getCreateTime);
		return baseMapper.selectList(wrapper);
	}

	private LambdaQueryWrapper buildQueryWrapper(TGzEmpSkillSearchVo entity) {
		LambdaQueryWrapper<TGzEmpSkill> wrapper = Wrappers.lambdaQuery();

		if (Common.isNotNull(entity.getCreateName())) {
			wrapper.eq(TGzEmpSkill::getCreateName, entity.getCreateName());
		}
		return wrapper;
	}

}
