/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.archives.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TGzEmpWork;
import com.yifu.cloud.plus.v1.yifu.archives.mapper.TGzEmpWorkMapper;
import com.yifu.cloud.plus.v1.yifu.archives.service.TGzEmpWorkService;
import lombok.RequiredArgsConstructor;
import lombok.extern.log4j.Log4j2;
import org.springframework.stereotype.Service;

import com.yifu.cloud.plus.v1.yifu.archives.vo.TGzEmpWorkSearchVo;

import java.util.List;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.common.core.util.*;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;


/**
 * 瓜子工作经历
 *
 * @author chenyx
 * @date 2025-06-13 15:19:04
 */
@Log4j2
@Service
@RequiredArgsConstructor
public class TGzEmpWorkServiceImpl extends ServiceImpl<TGzEmpWorkMapper, TGzEmpWork> implements TGzEmpWorkService {
	/**
	 * 瓜子工作经历简单分页查询
	 *
	 * @param tGzEmpWork 瓜子工作经历
	 * @return
	 */
	@Override
	public IPage<TGzEmpWork> getTGzEmpWorkPage(Page<TGzEmpWork> page, TGzEmpWorkSearchVo tGzEmpWork) {
		return baseMapper.getTGzEmpWorkPage(page, tGzEmpWork);
	}

	@Override
	public List<TGzEmpWork> noPageDiy(TGzEmpWorkSearchVo searchVo) {
		LambdaQueryWrapper<TGzEmpWork> wrapper = buildQueryWrapper(searchVo);
		List<String> idList = Common.getList(searchVo.getIds());
		if (Common.isNotNull(idList)) {
			wrapper.in(TGzEmpWork::getId, idList);
		}

		wrapper.orderByDesc(BaseEntity::getCreateTime);
		return baseMapper.selectList(wrapper);
	}

	private LambdaQueryWrapper buildQueryWrapper(TGzEmpWorkSearchVo entity) {
		LambdaQueryWrapper<TGzEmpWork> wrapper = Wrappers.lambdaQuery();

		if (Common.isNotNull(entity.getCreateName())) {
			wrapper.eq(TGzEmpWork::getCreateName, entity.getCreateName());
		}
		return wrapper;
	}

}
