package com.yifu.cloud.plus.v1.business.entity.manager;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.time.LocalDateTime;


/**
 * 部门数据权限表
 *
 * @author fxj
 * @date 2021-08-11 16:54:35
 */
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("organ_data_permission")
@Schema(description = "部门数据权限表")
public class OrganDataPermission extends Model<OrganDataPermission> {
    private static final long serialVersionUID = 1L;
    /**
     * 主键
     */
    @TableId(type = IdType.ASSIGN_ID)
    @Schema(description = "主键")
    private String id;
    /**
     * 是否是所有者
     */
    @Length(max = 1, message = "是否是所有者不能超过1个字符")
    @ExcelAttribute(name = "是否是所有者", maxLength = 1)
    @Schema(description = "是否是所有者")
    private String isOwner;
    /**
     * 部门ID
     */
    @Length(max = 32, message = "部门ID不能超过32个字符")
    @ExcelAttribute(name = "部门ID", maxLength = 32)
    @Schema(description = "部门ID")
    private String organId;
    /**
     * 部门CODE
     */
    @Length(max = 32, message = "部门CODE不能超过32个字符")
    @ExcelAttribute(name = "部门CODE", maxLength = 32)
    @Schema(description = "部门CODE")
    private String organCode;
    /**
     * 授权来源
     */
    @Length(max = 50, message = "授权来源不能超过50个字符")
    @ExcelAttribute(name = "授权来源", maxLength = 50)
    @Schema(description = "授权来源")
    private String permissonSrc;
    /**
     * 被授权人
     */
    @NotBlank(message = "被授权人不能为空")
    @Length(max = 32, message = "被授权人不能超过32个字符")
    @ExcelAttribute(name = "被授权人", isNotEmpty = true, errorInfo = "被授权人不能为空", maxLength = 32)
    @Schema(description = "被授权人")
    private String bePermissonUser;
    /**
     * 被授权时间
     */
    @ExcelAttribute(name = "被授权时间")
    @Schema(description = "被授权时间")
    private LocalDateTime bePermissionTime;
    /**
     * 备注
     */
    @Length(max = 50, message = "备注不能超过50个字符")
    @ExcelAttribute(name = "备注", maxLength = 50)
    @Schema(description = "备注")
    private String remark;
    /**
     * 授权人
     */
    @Length(max = 32, message = "授权人不能超过32个字符")
    @ExcelAttribute(name = "授权人", maxLength = 32)
    @Schema(description = "授权人")
    private String permissionUser;
}
