package com.yifu.cloud.plus.v1.business.entity.salary;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.math.BigDecimal;
import lombok.Data;

/**
 * 个人薪资变动统计表
 * @TableName t_salary_statistics_personal
 */
@TableName(value ="t_salary_statistics_personal")
@Data
public class TSalaryStatisticsPersonal implements Serializable {
    @TableField(exist = false)
    private static final long serialVersionUID = 1L;
    /**
     * 主键
     */
    @TableId(type = IdType.ASSIGN_ID)
    private String id;
    /**
     * 电信工号
     */
    private String telecomNumber;
    /**
     * 姓名
     */
    private String empName;
    /**
     * 工资月份-yyyyMM
     */
    private String salaryMonth;
    /**
     * 人数 正整数
     */
    private Integer peopleNumber;
    /**
     * 人数差值 正整数
     */
    private Integer peopleNumberOffset;
    /**
     * 薪酬应发 8位整数 2位小数
     */
    private BigDecimal payableSalary;
    /**
     * 薪酬应发差额 8位整数 2位小数
     */
    private BigDecimal payableSalaryOffset;
    /**
     * 薪酬应发差额标识 0减少 1不变 2增加
     */
    private String payableSalaryFlag;
    /**
     * 激励应发 8位整数 2位小数
     */
    private BigDecimal payableIncentiveSalary;
    /**
     * 激励应发差额 8位整数 2位小数
     */
    private BigDecimal payableIncentiveSalaryOffset;
    /**
     * 激励应发差额标识 0减少 1不变 2增加
     */
    private String payableIncentiveSalaryFlag;
    /**
     * 其他应发 8位整数 2位小数
     */
    private BigDecimal payableOtherSalary;
    /**
     * 其他应发差额 8位整数 2位小数
     */
    private BigDecimal payableOtherSalaryOffset;
    /**
     * 其他应发差额标识 0减少 1不变 2增加
     */
    private String payableOtherSalaryFlag;
    /**
     * 应发合计 9位整数 2位小数
     */
    private BigDecimal payableTotal;
    /**
     * 应发合计差额 9位整数 2位小数
     */
    private BigDecimal payableTotalOffset;
    /**
     * 应发合计差额标识 0减少 1不变 2增加
     */
    private String payableTotalFlag;
    /**
     * 单位社保 6位整数 2位小数
     */
    private BigDecimal companySocial;
    /**
     * 单位社保差额 6位整数 2位小数
     */
    private BigDecimal companySocialOffset;
    /**
     * 单位社保差额标识 0减少 1不变 2增加
     */
    private String companySocialFlag;
    /**
     * 单位公积金 6位整数 2位小数
     */
    private BigDecimal companyAccFund;
    /**
     * 单位公积金差额 6位整数 2位小数
     */
    private BigDecimal companyAccFundOffset;
    /**
     * 单位公积金差额标识 0减少 1不变 2增加
     */
    private String companyAccFundFlag;
    /**
     * 个人社保 6位整数 2位小数
     */
    private BigDecimal personalSocial;
    /**
     * 个人社保差额 6位整数 2位小数
     */
    private BigDecimal personalSocialOffset;
    /**
     * 个人社保差额标识 0减少 1不变 2增加
     */
    private String personalSocialFlag;
    /**
     * 个人公积金 6位整数 2位小数
     */
    private BigDecimal personalAccFund;
    /**
     * 个人公积金差额 6位整数 2位小数
     */
    private BigDecimal personalAccFundOffset;
    /**
     * 个人公积金差额标识 0减少 1不变 2增加
     */
    private String personalAccFundFlag;
    /**
     * 个人所得税 6位整数 2位小数
     */
    private BigDecimal indIncomeTax;
    /**
     * 个人所得税差额 6位整数 2位小数
     */
    private BigDecimal indIncomeTaxOffset;
    /**
     * 个人所得税差额标识 0减少 1不变 2增加
     */
    private String indIncomeTaxFlag;
    /**
     * 其他扣款 6位整数 2位小数
     */
    private BigDecimal otherDedutions;
    /**
     * 其他扣款差额 6位整数 2位小数
     */
    private BigDecimal otherDedutionOffset;
    /**
     * 其他扣款差额标识 0减少 1不变 2增加
     */
    private String otherDedutionFalg;
    /**
     * 扣款合计 7位整数 2位小数
     */
    private BigDecimal dedutionTotal;
    /**
     * 扣款合计差额 7位整数 2位小数
     */
    private BigDecimal dedutionTotalOffset;
    /**
     * 扣款合计差额标识 0减少 1不变 2增加
     */
    private String dedutionTotalFlag;
    /**
     * 实发工资 8位整数 2位小数
     */
    private BigDecimal actualSalary;
    /**
     * 实发工资差额 8位整数 2位小数
     */
    private BigDecimal actualSalaryOffset;
    /**
     * 实发工资差额标识 0减少 1不变 2增加
     */
    private String actualSalaryFlag;
}