package com.yifu.cloud.plus.v1.business.entity.system;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.time.LocalDateTime;
import java.util.List;

import org.hibernate.validator.constraints.Length;
import org.springframework.format.annotation.DateTimeFormat;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;


/**
 * B端部门表
 *
 * @author hgw
 * @date 2021-08-10 10:38:44
 */
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("t_bus_dept")
@Schema(description = "B端部门表")
public class TBusDept extends Model<TBusDept> {
     private static final long serialVersionUID = 1L;
     /**
      * 主键
      */
     @TableId(type = IdType.AUTO)
     @Schema(description = "主键")
     private Integer id;
     /**
      * 部门名称
      */
     @Length(max = 100, message = "部门名称不能超过100个字符")
     @ExcelAttribute(name = "部门名称", maxLength = 100)
     @Schema(description = "部门名称")
     private String name;
     /**
      * 级别
      */
     @ExcelAttribute(name = "级别")
     @Schema(description = "级别")
     private Integer level;
     /**
      * 父级id
      */
     @NotNull(message = "父级id不能为空")
     @ExcelAttribute(name = "父级id", isNotEmpty = true, errorInfo = "父级id不能为空")
     @Schema(description = "父级id")
     private Integer pid;
     /**
      * 创建人id
      */
     @NotBlank(message = "创建人id不能为空")
     @Length(max = 32, message = "创建人id不能超过32个字符")
     @ExcelAttribute(name = "创建人id", isNotEmpty = true, errorInfo = "创建人id不能为空", maxLength = 32)
     @Schema(description = "创建人id")
     private String createUserId;
     /**
      * 创建人姓名
      */
     @Length(max = 50, message = "创建人姓名不能超过50个字符")
     @ExcelAttribute(name = "创建人姓名", maxLength = 50)
     @Schema(description = "创建人姓名")
     private String createUserName;
     /**
      * 创建时间
      */
	 @JsonFormat(shape = JsonFormat.Shape.STRING, pattern="yyyy-MM-dd HH:mm:ss")
	 @DateTimeFormat( pattern = "yyyy-MM-dd HH:mm:ss")
     @ExcelAttribute(name = "创建时间")
     @Schema(description = "创建时间")
     private LocalDateTime createTime;
     /**
      * 树标记：父tree_logo_id
      */
     @Length(max = 200, message = "树标记：父tree_logo_id不能超过200个字符")
     @ExcelAttribute(name = "树标记：父tree_logo_id", maxLength = 200)
     @Schema(description = "树标记：父tree_logo_id")
     private String treeLogo;
     /**
      * 删除标志：0未删除
      */
     @Length(max = 1, message = "删除标志：0未删除不能超过1个字符")
     @ExcelAttribute(name = "删除标志：0未删除", maxLength = 1)
     @Schema(description = "删除标志：0未删除")
     private Integer deleteFlag;

     /**
      * 部门子树
      */
     @TableField(exist = false)
     private List<TBusDept> children;

     /**
      * 上级部门
      */
     @TableField(exist = false)
     private String parentName;

}
