package com.yifu.cloud.plus.v1.business.entity.vacation;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * 假期监控清零日志表
 * @TableName t_vacation_monitor_clear_log
 */
@TableName(value ="t_vacation_monitor_clear_log")
@Data
public class TVacationMonitorClearLog extends Model<TVacationMonitorClearLog> {
    /**
     * 主键
     */
	@TableId(type = IdType.ASSIGN_ID)
    private String id;

    /**
     * 清零说明
     */
    private String clearNote;

    /**
     * 清零时长
     */
    private BigDecimal clearDuration;

    /**
     * 年份
     */
    private String vacationYear;

    /**
     * 清零人姓名
     */
    private String clearUser;

    /**
     * 清零人id
     */
    private String clearUserId;

    /**
     * 清零时间
     */
    private LocalDateTime clearTime;

    /**
     * 年假监控id
     */
    private String vacationMonitorId;

    @TableField(exist = false)
    private static final long serialVersionUID = 1L;
}