package com.yifu.cloud.plus.v1.business.query.vacation;

import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @description: 假勤信息表 分页查询query
 * @author: wangweiguo
 * @date: 2021-08-20
*/
@Setter
@Getter
@ToString
public class TVacationInfoQuery implements Serializable  {

    /**
     * b端员工工号
     */
	@Schema(description = "b端员工工号")
	private String businessTelecomNumber;

    /**
     * 人员姓名
     */
	@Schema(description = "人员姓名")
	private String empName;

    /**
     * 身份证号码
     */
	@Schema(description = "身份证号码")
	private String empIdcard;

    /**
     * b端岗位
     */
	@Schema(description = "岗位")
	private String businessPost;
    /**
     * 部门id
     */
	@Schema(description = "部门id")
	private Integer departId;

    /**
     * 假勤类型（字典值）
     */
	@Schema(description = "假勤类型（字典值）")
	private String vacationType;

    /**
     * 假勤开始时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	@Schema(description = "假勤开始时间 yyyy-MM-dd HH:mm:ss")
	private LocalDateTime vacationStartTime;

    /**
     * 假勤结束时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	@Schema(description = "假勤结束时间 yyyy-MM-dd HH:mm:ss")
	private LocalDateTime vacationEndTime;

    /**
     * 假勤状态 0待休 1休假中 2到期待销假 3已销假
     */
	@Schema(description = "假勤状态 0待休 1休假中 2到期待销假 3已销假")
	private String vacationStatus;

    /**
    * 当前页码 默认为1
    */
	@Schema(description = "当前页码 默认为1")
	long current = 1;

    /**
    * 每页数量 默认为10
    */
	@Schema(description = "每页数量 默认为10")
	long size = 10;

    /**
    * 排序字段
    */
	@Schema(description = "排序字段")
	List<OrderItem> orders;
}

