package com.yifu.cloud.plus.v1.business.vo.salary;

import com.yifu.cloud.plus.v1.business.entity.salary.TBusSalaryConfigTitleRes;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.util.ArrayList;
import java.util.List;

/**
 * @Description: 工资原表识别导入vo
 * @Author: hgw
 * @Date: 2021/1/12 19:45
 * @return:
 **/
@Data
public class SalaryImportVo {

     @Schema(description = "表格数据list")
     private List<List<KeyValueVo>> contentList = new ArrayList<>();

     @Schema(description = "配置关系")
     private List<TBusSalaryConfigTitleRes> resList = new ArrayList<>();

     @Schema(description = "部门id")
     private String deptId;

     @Schema(description = "工资月份")
     private String salaryMonth;

     @Schema(description = "保存类型：0:保存；1不保存")
     private Integer saveType;
}
