package com.yifu.cloud.plus.v1.business.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.business.entity.TPolicy;
import com.yifu.cloud.plus.v1.business.service.TPolicyService;
import com.yifu.cloud.plus.v1.yifu.common.core.util.Common;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.YifuUser;
import com.yifu.cloud.plus.v1.yifu.common.log.annotation.SysLog;
import com.yifu.cloud.plus.v1.yifu.common.security.util.SecurityUtils;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.AllArgsConstructor;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import java.time.LocalDateTime;


/**
 * @Author fxj
 * @Description B端-政策
 * @Date 16:47 2023/1/3
 * @Param
 * @return
**/
@RestController
@AllArgsConstructor
@RequestMapping("/customerBusiness/tpolicy")
@Tag(name = "B端-政策")
public class TPolicyController {

     private final TPolicyService tPolicyService;

     /**
      * 简单分页查询
      *
      * @param page    分页对象
      * @param tPolicy B端-政策
      * @return
      */
     @Operation(description = "简单分页查询")
     @GetMapping("/page")
     public R<IPage<TPolicy>> getTPolicyPage(Page<TPolicy> page, TPolicy tPolicy) {
          // 倒序
          OrderItem order = new OrderItem();
          order.setColumn("CREATE_TIME");
          order.setAsc(false);
          page.addOrder(order);
          return new R<>(tPolicyService.getTPolicyPage(page, tPolicy));
     }


     /**
      * 通过id查询单条记录
      *
      * @param id
      * @return R
      */
     @Operation(description = "id查询")
     @GetMapping("/{id}")
     public R<TPolicy> getById(@PathVariable("id") String id) {
          TPolicy policy = tPolicyService.getById(id);
          if (policy != null) {
               policy.setReadings(policy.getReadings() == null ? 1 : policy.getReadings() + 1);
               tPolicyService.updateById(policy);
          }
          return new R<>(policy);
     }

     /**
      * 新增记录
      *
      * @param tPolicy
      * @return R
      */
     @Operation(description = "新增(wxhr:tpolicy_add)")
     @PostMapping
     @PreAuthorize("@pms.hasPermission('wxhr:tpolicy_add')")
     public R<Boolean> save(@RequestBody TPolicy tPolicy) {
          if (Common.isEmpty(tPolicy.getTitle())) {
               return R.failed("请输入标题！");
          }
          YifuUser user = SecurityUtils.getUser();
          tPolicy.setCreateUser(String.valueOf(user.getId()));
          tPolicy.setCreateTime(LocalDateTime.now());
          return new R<>(tPolicyService.save(tPolicy));
     }

     /**
      * 修改记录
      *
      * @param tPolicy
      * @return R
      */
     @Operation(description = "修改(wxhr:tpolicy_edit)")
     @SysLog("修改B端-政策")
     @PutMapping
     @PreAuthorize("@pms.hasPermission('wxhr:tpolicy_edit')")
     public R<Boolean> update(@RequestBody TPolicy tPolicy) {
          return new R<>(tPolicyService.updateById(tPolicy));
     }

     /**
      * 通过id删除一条记录
      *
      * @param id
      * @return R
      */
     @Operation(description = "删除(wxhr:tpolicy_del)")
     @SysLog("删除B端-政策")
     @DeleteMapping("/{id}")
     @PreAuthorize("@pms.hasPermission('wxhr:tpolicy_del')")
     public R<Boolean> removeById(@PathVariable String id) {
          return new R<>(tPolicyService.removeById(id));
     }

}
