package com.yifu.cloud.plus.v1.business.controller.salary;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.business.entity.salary.TBusSalaryConfig;
import com.yifu.cloud.plus.v1.business.service.salary.TBusSalaryConfigService;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.log.annotation.SysLog;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.util.List;


/**
 * B端-薪资配置
 *
 * @author hgw
 * @date 2021-09-06 11:10:32
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/tbussalaryconfig")
@Tag(name = "B端-薪资配置")
public class TBusSalaryConfigController {

     private final TBusSalaryConfigService tBusSalaryConfigService;

     /**
      * 简单分页查询
      *
      * @param page             分页对象
      * @param tBusSalaryConfig B端-薪资配置
      * @return
      */
     @Operation(summary = "简单分页查询")
     @GetMapping("/page")
     public R<IPage<TBusSalaryConfig>> getTBusSalaryConfigPage(Page<TBusSalaryConfig> page, TBusSalaryConfig tBusSalaryConfig) {
          return new R<>(tBusSalaryConfigService.getTBusSalaryConfigPage(page, tBusSalaryConfig));
     }

     /**
      * @Description: 列表(专为前端展现所用)
      * @Author: hgw
      * @Date: 2021/9/13 16:50
      * @return:
      **/
     @Operation(description = "列表(专为前端展现所用)")
     @GetMapping("/getConfigList")
     public R<List<TBusSalaryConfig>> getConfigList() {
          return new R<>(tBusSalaryConfigService.getConfigList());
     }


     /**
      * 通过id查询单条记录
      *
      * @param id
      * @return R
      */
     @Operation(description = "id查询")
     @GetMapping("/{id}")
     public R<TBusSalaryConfig> getById(@PathVariable("id") String id) {
          return new R<>(tBusSalaryConfigService.getById(id));
     }

     /**
      * 新增记录
      *
      * @param tBusSalaryConfig
      * @return R
      */
     @Operation(description = "新增(yifu-hro-business:tbussalaryconfig_add)")
     @PostMapping
     @PreAuthorize("@pms.hasPermission('yifu-hro-business:tbussalaryconfig_add')")
     public R<Boolean> save(@Valid @RequestBody TBusSalaryConfig tBusSalaryConfig) {
          return new R<>(tBusSalaryConfigService.save(tBusSalaryConfig));
     }

     /**
      * 修改记录
      *
      * @param tBusSalaryConfig
      * @return R
      */
     @Operation(description = "修改(yifu-hro-business:tbussalaryconfig_edit)")
     @SysLog("修改B端-薪资配置")
     @PutMapping
     @PreAuthorize("@pms.hasPermission('yifu-hro-business:tbussalaryconfig_edit')")
     public R<Boolean> update(@RequestBody TBusSalaryConfig tBusSalaryConfig) {
          return new R<>(tBusSalaryConfigService.updateById(tBusSalaryConfig));
     }

     /**
      * 通过id删除一条记录
      *
      * @param id
      * @return R
      */
     @Operation(description = "删除(yifu-hro-business:tbussalaryconfig_del)")
     @SysLog("删除B端-薪资配置")
     @DeleteMapping("/{id}")
     @PreAuthorize("@pms.hasPermission('yifu-hro-business:tbussalaryconfig_del')")
     public R<Boolean> removeById(@PathVariable String id) {
          return new R<>(tBusSalaryConfigService.removeById(id));
     }

}
