package com.yifu.cloud.plus.v1.business.controller.salary;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.business.entity.salary.TBusSalaryItem;
import com.yifu.cloud.plus.v1.business.service.salary.TBusSalaryItemService;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.log.annotation.SysLog;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.AllArgsConstructor;
import lombok.RequiredArgsConstructor;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.util.ArrayList;
import java.util.List;


/**
 * B端-薪酬明细表
 *
 * @author hgw
 * @date 2021-09-06 11:10:32
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/tbussalaryitem")
@Tag(name = "B端-薪酬明细表")
public class TBusSalaryItemController {

     private final TBusSalaryItemService tBusSalaryItemService;

     /**
      * 简单分页查询
      *
      * @param page           分页对象
      * @param tBusSalaryItem B端-薪酬明细表
      * @return
      */
     @Operation(summary = "简单分页查询")
     @GetMapping("/page")
     public R<IPage<TBusSalaryItem>> getTBusSalaryItemPage(Page<TBusSalaryItem> page, TBusSalaryItem tBusSalaryItem) {
          return new R<>(tBusSalaryItemService.getTBusSalaryItemPage(page, tBusSalaryItem));
     }

     /**
      * @param salaryId
      * @Description: 工资详情
      * @Author: hgw
      * @Date: 2021/9/15 15:18
      * @return: com.yifu.cloud.v1.common.core.util.R<com.baomidou.mybatisplus.core.metadata.IPage < com.yifu.cloud.v1.hrobusiness.api.entity.salary.TBusSalaryItem>>
      **/
     @Operation(summary = "工资详情")
     @GetMapping("/getListBySalaryId")
     public R<List<TBusSalaryItem>> getListBySalaryId(@RequestParam String salaryId) {
		  List<String> salaryIdList = new ArrayList<>();
		  salaryIdList.add(salaryId);
          return new R<>(tBusSalaryItemService.getListBySalaryId(salaryIdList));
     }


     /**
      * 通过id查询单条记录
      *
      * @param id
      * @return R
      */
     @Operation(summary = "id查询")
     @GetMapping("/{id}")
     public R<TBusSalaryItem> getById(@PathVariable("id") String id) {
          return new R<>(tBusSalaryItemService.getById(id));
     }

     /**
      * 新增记录
      *
      * @param tBusSalaryItem
      * @return R
      */
     @Operation(summary = "新增(yifu-hro-business:tbussalaryitem_add)")
     @PostMapping
     @PreAuthorize("@pms.hasPermission('yifu-hro-business:tbussalaryitem_add')")
     public R<Boolean> save(@Valid @RequestBody TBusSalaryItem tBusSalaryItem) {
          return new R<>(tBusSalaryItemService.save(tBusSalaryItem));
     }

     /**
      * 修改记录
      *
      * @param tBusSalaryItem
      * @return R
      */
     @Operation(summary = "修改(yifu-hro-business:tbussalaryitem_edit)")
     @SysLog("修改B端-薪酬明细表")
     @PutMapping
     @PreAuthorize("@pms.hasPermission('yifu-hro-business:tbussalaryitem_edit')")
     public R<Boolean> update(@RequestBody TBusSalaryItem tBusSalaryItem) {
          return new R<>(tBusSalaryItemService.updateById(tBusSalaryItem));
     }

     /**
      * 通过id删除一条记录
      *
      * @param id
      * @return R
      */
     @Operation(summary = "删除(yifu-hro-business:tbussalaryitem_del)")
     @SysLog("删除B端-薪酬明细表")
     @DeleteMapping("/{id}")
     @PreAuthorize("@pms.hasPermission('yifu-hro-business:tbussalaryitem_del')")
     public R<Boolean> removeById(@PathVariable String id) {
          return new R<>(tBusSalaryItemService.removeById(id));
     }

}
