package com.yifu.cloud.plus.v1.business.controller.system;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.business.entity.system.TBusWarning;
import com.yifu.cloud.plus.v1.business.service.system.TBusWarningService;
import com.yifu.cloud.plus.v1.yifu.common.core.util.DateUtil;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.security.annotation.Inner;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.AllArgsConstructor;
import org.springframework.web.bind.annotation.*;


/**
 * B端预警表
 *
 * @author hgw
 * @date 2021-08-20 17:39:51
 */
@RestController
@AllArgsConstructor
@RequestMapping("/tbuswarning")
@Tag(name = "B端预警表")
public class TBusWarningController {

     private final TBusWarningService tBusWarningService;

     /**
      * 简单分页查询
      *
      * @param page        分页对象
      * @param tBusWarning B端预警表
      * @return
      */
	 @Operation(summary = "简单分页查询", description = "简单分页查询")
	 @GetMapping("/page")
     public R<IPage<TBusWarning>> getTBusWarningPage(Page<TBusWarning> page, TBusWarning tBusWarning) {
          return new R<>(tBusWarningService.getTBusWarningPage(page, tBusWarning));
     }


     /**
      * 通过id查询单条记录
      *
      * @param id
      * @return R
      */
	 @Operation(summary = "id查询", description = "id查询")
	 @GetMapping("/{id}")
     public R<TBusWarning> getById(@PathVariable("id") String id) {
          return new R<>(tBusWarningService.getById(id));
     }

     /**
      * 获取所有要自动发送的主表，以及人员信息进行定时任务发送短信
      *
      * @return
      * @Author:hgw
      * @Date 2021-8-24 18:18:01
      */
	 @Operation(summary = "获取所有要自动发送的主表，以及人员信息进行定时任务发送", description = "获取所有要自动发送的主表，以及人员信息进行定时任务发送")
	 @Inner
	 @PostMapping("/inner/doBatchSendBusSms")
     public void doBatchSendBusSms() {
          tBusWarningService.doBatchSendBusSms();
     }

     /**
      * 更新当日所有发送的短信状态
      *
      * @return
      * @Author:hgw
      * @Date 2021-8-24 18:18:06
      */
	 @Operation(summary = "更新当日所有发送的短信状态", description = "更新当日所有发送的短信状态")
	 @Inner
	 @PostMapping("/inner/doUpdateSendBusSmsStatus")
     public void doUpdateSendBusSmsStatus() {
          tBusWarningService.doUpdateSendBusSmsStatus(DateUtil.getCurrentDateString(DateUtil.ISO_DATE_FORMAT));
     }

}
