package com.yifu.cloud.plus.v1.business.controller.vacation;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yifu.cloud.plus.v1.business.dto.vacation.AddOrUpdateTVacationInfoDTO;
import com.yifu.cloud.plus.v1.business.dto.vacation.ChangeVacationStatusDTO;
import com.yifu.cloud.plus.v1.business.dto.vacation.UpdateVacationRedundancyDTO;
import com.yifu.cloud.plus.v1.business.entity.vacation.TVacationInfo;
import com.yifu.cloud.plus.v1.business.query.vacation.TVacationInfoQuery;
import com.yifu.cloud.plus.v1.business.service.vacation.TVacationInfoService;
import com.yifu.cloud.plus.v1.business.vo.vacation.TVacationInfoVO;
import com.yifu.cloud.plus.v1.yifu.common.core.util.ErrorMessage;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.security.annotation.Inner;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.util.List;

/**
 * 假勤信息表 controller
 * @author: huyc
 * @date: 2023/1/13
*/
@RestController
@RequiredArgsConstructor
@RequestMapping("/vacationInfo")
@Tag(name = "假勤信息表相关api")
public class TVacationInfoController {

    private final TVacationInfoService tVacationInfoService;

    /**
     * 分页查询: 条件分页查询
     * @param query 查询条件
     * @return: R<IPage<TVacationInfoVO>>
	 * @author: huyc
	 * @date: 2023/1/13
    */
	@Operation(summary = "分页查询", description = "分页查询")
	@GetMapping("/getListByPage")
    public R<IPage<TVacationInfoVO>> getListByPage(TVacationInfoQuery query) {
        return this.tVacationInfoService.getListByPage(query);
    }

    /**
     * 导入: 通过json串格式导入假勤信息
     * @param jsonStr json字符串数据
     * @return: com.yifu.cloud.v1.common.core.util.R<java.lang.Boolean>
	 * @author: huyc
	 * @date: 2023/1/13
    */
	@Operation(summary = "导入: 通过json串格式导入假勤信息", description = "导入: 通过json串格式导入假勤信息")
	@PostMapping("/batchImportByJsonStr")
    public R<List<ErrorMessage>> batchImportByJsonStr(@RequestBody String jsonStr) {
        return this.tVacationInfoService.batchImportByJsonStr(jsonStr);
    }

    /**
     * 查询：根据条件出列表
     * @param query 查询条件
     * @return: IPage<com.yifu.cloud.v1.hrobusiness.api.vo.vacation.TVacationInfoVO>>
	 * @author: huyc
	 * @date: 2023/1/13
    */
	@Operation(summary = "查询：根据条件出列表", description = "查询：根据条件出列表")
	@GetMapping("/getList")
    public R<List<TVacationInfoVO>> getList(TVacationInfoQuery query) {
        return this.tVacationInfoService.getList(query);
    }

    /**
     * 查询-详情：根据id查询数据
     * @param id
     * @return: R<TVacationInfoVO>
	 * @author: huyc
	 * @date: 2023/1/13
    */
	@Operation(summary = "查询-详情：根据id查询数据", description = "查询-详情：根据id查询数据")
	@GetMapping("/{id}")
    public R<TVacationInfoVO> getById(@PathVariable("id") String id) {
        return this.tVacationInfoService.getDataById(id);
    }

    /**
     * 添加：新增-单条-添加一条记录
     * @param dto
     * @return: R<TVacationInfo>
	 * @author: huyc
	 * @date: 2023/1/13
    */
	@Operation(summary = "添加：新增-单条-添加一条记录", description = "添加：新增-单条-添加一条记录")
	@PostMapping
    public R<TVacationInfo> save(@RequestBody @Valid AddOrUpdateTVacationInfoDTO dto) {
        return this.tVacationInfoService.saveData(dto);
    }

    /**
     * 销假：单条-根据id更新记录
     * @param dto dto
     * @return: R<Boolean>
	 * @author: huyc
	 * @date: 2023/1/13
    */
	@Operation(summary = "销假：单条-根据id更新", description = "销假：单条-根据id更新")
	@PostMapping("/vacationEnd/{id}")
    public R<Boolean> vacationEnd(@RequestBody @Valid ChangeVacationStatusDTO dto) {
        return this.tVacationInfoService.vacationEnd(dto);
    }

    /**
     * 删除-单条：根据id删除记录
     * @param id
     * @return: R<Boolean>
	 * @author: huyc
	 * @date: 2023/1/13
    */
	@Operation(summary = "根据id删除记录", description = "根据id删除记录")
	@DeleteMapping("/{id}")
    public R<Boolean> delById(@PathVariable("id") String id) {
        return this.tVacationInfoService.removeDataById(id);
    }

    /**
     * @description 更新假勤信息中的冗余信息
	 * @author: huyc
	 * @date: 2023/1/13
     * @param dtoList 更新冗余字段dto集合
     * @return com.yifu.cloud.v1.common.core.util.R<java.lang.Boolean>
     **/
    @Inner
    @PostMapping("/inner/updateRedundancyEmployeeFields")
    public void updateRedundancyEmployeeFields(@RequestBody List<UpdateVacationRedundancyDTO> dtoList) {
        tVacationInfoService.updateRedundancyEmployeeFields(dtoList);
    }

}

