package com.yifu.cloud.plus.v1.business.service.salary.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yifu.cloud.plus.v1.business.entity.salary.TBusSalaryConfig;
import com.yifu.cloud.plus.v1.business.mapper.salary.TBusSalaryConfigMapper;
import com.yifu.cloud.plus.v1.business.service.salary.TBusSalaryConfigService;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.CommonConstants;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * B端-薪资配置
 *
 * @author hgw
 * @date 2021-09-06 11:10:32
 */
@Service
public class TBusSalaryConfigServiceImpl extends ServiceImpl<TBusSalaryConfigMapper, TBusSalaryConfig> implements TBusSalaryConfigService {

     /**
      * B端-薪资配置简单分页查询
      *
      * @param tBusSalaryConfig B端-薪资配置
      * @return
      */
     @Override
     public IPage<TBusSalaryConfig> getTBusSalaryConfigPage(Page<TBusSalaryConfig> page, TBusSalaryConfig tBusSalaryConfig) {
          return baseMapper.getTBusSalaryConfigPage(page, tBusSalaryConfig);
     }

     /**
      * B端-薪资配置简单list
      *
      * @return
      */
     @Override
     public List<TBusSalaryConfig> getConfigList() {
          return baseMapper.getConfigList();
     }

     /**
      * 获取必要列的Map
      */
     @Override
     public Map<String, Integer> getMustMap() {
          List<String> mustList = baseMapper.getMustList();
          Map<String, Integer> mustMap = new HashMap<>();
          if (mustList != null && !mustList.isEmpty()) {
               for (String name : mustList) {
                    mustMap.put(name, CommonConstants.ONE_INT);
               }
          }
          return mustMap;
     }

}
