package com.yifu.cloud.plus.v1.business.service.system.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yifu.cloud.plus.v1.business.entity.system.TBusWarning;
import com.yifu.cloud.plus.v1.business.entity.system.TBusWarningEmployee;
import com.yifu.cloud.plus.v1.business.mapper.system.TBusWarningEmployeeMapper;
import com.yifu.cloud.plus.v1.business.mapper.system.TBusWarningMapper;
import com.yifu.cloud.plus.v1.business.service.system.TBusWarningEmployeeService;
import com.yifu.cloud.plus.v1.business.util.SmsTaskExecute;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.CommonConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.util.Common;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.core.util.alisms.AliSmsResult;
import com.yifu.cloud.plus.v1.yifu.common.core.util.alisms.ParamVo;
import com.yifu.cloud.plus.v1.yifu.common.core.util.alisms.YiFuSmsTookit;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.YifuUser;
import com.yifu.cloud.plus.v1.yifu.common.security.util.SecurityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;

/**
 * B端短信发送记录表
 *
 * @author hgw
 * @date 2021-08-23 16:27:34
 */
@Service("tBusWarningEmployeeService")
public class TBusWarningEmployeeServiceImpl extends ServiceImpl<TBusWarningEmployeeMapper, TBusWarningEmployee> implements TBusWarningEmployeeService {

     @Autowired
     private TBusWarningMapper busWarningMapper;
     @Autowired
     private SmsTaskExecute smsTaskExecute;

     /**
      * B端短信发送记录表简单分页查询
      *
      * @param tBusWarningEmployee B端短信发送记录表
      * @return
      */
     @Override
     public IPage<TBusWarningEmployee> getTBusWarningEmployeePage(Page<TBusWarningEmployee> page, TBusWarningEmployee tBusWarningEmployee) {
          return baseMapper.getTBusWarningEmployeePage(page, tBusWarningEmployee);
     }

     @Override
     public List<TBusWarningEmployee> getTBusWarningEmployeeListToday(String dateStr) {
          return baseMapper.getTBusWarningEmployeeListToday(dateStr);
     }

     @Override
     public List<TBusWarningEmployee> getByBizId(String bizId) {
          return baseMapper.getByBizId(bizId);
     }

     /**
      * @Description: 手动发送-单个
      * @Author: hgw
      * @Date: 2021/5/10 9:50
      * @return: java.util.List<com.yifu.cloud.v1.hrms.api.entity.TBusWarningEmployee>
      **/
     @Override
     public R<String> sendBusSms(TBusWarningEmployee smsEmployee) {
          if (smsEmployee.getId() == null) {
               return R.failed("员工列表id不可为空！");
          }
          if (Common.isEmpty(smsEmployee.getWarningId())) {
               return R.failed("配置主表id不可为空！");
          }
          TBusWarning si = busWarningMapper.selectById(smsEmployee.getWarningId());
          TBusWarningEmployee se = this.getById(smsEmployee.getId());

          if (si == null) {
               return R.failed("未找到配置主表");
          }
          if (se == null) {
               return R.failed("未找到员工信息");
          }
          YifuUser user = SecurityUtils.getUser();
          if (user == null || user.getId() == null) {
               return R.failed("未找到登录人员信息");
          }
          // 暂存的毫秒数
          String bizId = String.valueOf(System.currentTimeMillis());
          TBusWarningEmployee newSe = new TBusWarningEmployee();
          newSe.setBusinessTelecomNumber(se.getBusinessTelecomNumber());
          newSe.setCertType(se.getCertType());
          newSe.setNotUsedVacationDuration(se.getNotUsedVacationDuration());
          newSe.setBizId(bizId);
          newSe.setSendStatus(CommonConstants.ONE_STRING);
          newSe.setCreateUser(String.valueOf(user.getId()));
          newSe.setEmpIdcard(se.getEmpIdcard());
          newSe.setEmpName(se.getEmpName());
          newSe.setEmpPhone(se.getEmpPhone());
          newSe.setRemark(se.getRemark());
          newSe.setSendDate(LocalDateTime.now());
          newSe.setWarningId(si.getId());
          newSe.setBusDeptCode(se.getBusDeptCode());
          newSe.setBusDeptId(se.getBusDeptId());
          newSe.setBusDeptName(se.getBusDeptName());
          newSe.setUpdateStatus(CommonConstants.ZERO_STRING);
          // 自定义sql新增的，如果有新字段，请记得加sql（因为id是数据库自增的）
          baseMapper.saveNewEmployee(newSe);
          String empName = se.getEmpName();
          if (Common.isNotNull(empName)) {
               empName = empName.replaceAll("\\d+", "").replace("X", "");
          }

          List<String> phones = new ArrayList<>();
          phones.add(newSe.getEmpPhone());

          ParamVo paramVo = new ParamVo();
          paramVo.setName(empName);

          List<ParamVo> params = new ArrayList<>();
          if (si.getRemindType() != 2) {
               paramVo.setZhengjian(newSe.getCertType());
          } else {
               paramVo.setTime(newSe.getNotUsedVacationDuration());
          }
          params.add(paramVo);
          // 调用发送接口
          AliSmsResult asr = YiFuSmsTookit.sendBusBatchSms(phones, params, si.getSignName(), si.getModelCode());
          if (asr != null && Common.isNotNull(asr.getBizId())) {
               baseMapper.updateBizIdByBizId(asr.getBizId(), bizId);
               // 异步更新短信发送状态
               smsTaskExecute.querySendDetailTask(baseMapper, asr.getBizId(), se.getEmpPhone());
          }
          return R.ok(null,"正在发送中，请等待……");
     }

     /**
      * @Description: 复审到期日
      * @Author: hgw
      * @Date: 2021/8/24 17:54
      * @return: int
      **/
     @Override
     public int insertByReviewDate(String warningId, Integer userId, String bizId, Integer days) {
          return baseMapper.insertByReviewDate(warningId, userId, bizId, days);
     }

     /**
      * @Description: 证件到期日
      * @Author: hgw
      * @Date: 2021/8/24 17:54
      * @return: int
      **/
     @Override
     public int insertByTermValidityEnd(String warningId, Integer userId, String bizId, Integer days) {
          return baseMapper.insertByTermValidityEnd(warningId, userId, bizId, days);
     }

     /**
      * @Description: 年假未休时长
      * @Author: hgw
      * @Date: 2021/8/24 17:54
      * @return: int
      **/
     @Override
     public int insertByYearVacation(String warningId, Integer userId, String bizId) {
          return baseMapper.insertByYearVacation(warningId, userId, bizId);
     }

     /**
      * @Description: 获取假期结束人员姓名
      * @Author: hgw
      * @Date: 2021/8/24 17:54
      * @return: int
      **/
     @Override
     public String getVacationInfoEmpName() {
          return baseMapper.getVacationInfoEmpName();
     }

	/**
	 * @Description: 获取假期结束人员姓名
	 * @Author: hgw
	 * @Date: 2021/8/24 17:54
	 * @return: int
	 **/
	@Override
	public String getVacationEmpName() {
		return baseMapper.getVacationEmpName();
	}

}
