/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.check.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yifu.cloud.plus.v1.check.entity.TPreEmpCheckNum;
import com.yifu.cloud.plus.v1.check.mapper.TPreEmpCheckNumMapper;
import com.yifu.cloud.plus.v1.check.service.TPreEmpCheckNumService;
import lombok.extern.log4j.Log4j2;
import org.springframework.stereotype.Service;

/**
 * C端预入职校验身份证与手机号限定调用表
 *
 * @author hgw
 * @date 2024-06-27 14:33:06
 */
@Log4j2
@Service
public class TPreEmpCheckNumServiceImpl extends ServiceImpl<TPreEmpCheckNumMapper, TPreEmpCheckNum> implements TPreEmpCheckNumService {
	/**
	 * C端预入职校验身份证与手机号限定调用表简单分页查询
	 *
	 * @return
	 */
	@Override
	public TPreEmpCheckNum getTPreEmpCheckNum(String deptId, String createDay) {
		return baseMapper.getTPreEmpCheckNum(deptId, createDay);
	}
}
