/*
 * Copyright (c) 2020 yifu4cloud Authors. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.yifu.cloud.plus.v1.yifu.common.core.constant;

/**
 * @author lengleng
 * @date 2019/2/1
 */
public interface SecurityConstants {

	/**
	 * 角色前缀
	 */
	String ROLE = "ROLE_";

	/**
	 * 前缀
	 */
	String PROJECT_PREFIX = "yifu_";

	/**
	 * 项目的license
	 */
	String PROJECT_LICENSE = "made by yifu";

	/**
	 * 内部
	 */
	String FROM_IN = "Y";

	/**
	 * 标志
	 */
	String FROM = "from";

	/**
	 * 默认登录URL
	 */
	String OAUTH_TOKEN_URL = "/oauth/token";

	/**
	 * grant_type
	 */
	String REFRESH_TOKEN = "refresh_token";

	/**
	 * 手机号登录
	 */
	String APP = "app";

	/**
	 * {bcrypt} 加密的特征码
	 */
	String BCRYPT = "{bcrypt}";

	/**
	 * sys_oauth_client_details 表的字段，不包括client_id、client_secret
	 */
	String CLIENT_FIELDS = "client_id, CONCAT('{noop}',client_secret) as client_secret, resource_ids, scope, "
			+ "authorized_grant_types, web_server_redirect_uri, authorities, access_token_validity, "
			+ "refresh_token_validity, additional_information, autoapprove";

	/**
	 * JdbcClientDetailsService 查询语句
	 */
	String BASE_FIND_STATEMENT = "select " + CLIENT_FIELDS + " from sys_oauth_client_details";

	/**
	 * 默认的查询语句
	 */
	String DEFAULT_FIND_STATEMENT = BASE_FIND_STATEMENT + " order by client_id";

	/**
	 * 按条件client_id 查询
	 */
	String DEFAULT_SELECT_STATEMENT = BASE_FIND_STATEMENT + " where client_id = ?";

	/***
	 * 资源服务器默认bean名称
	 */
	String RESOURCE_SERVER_CONFIGURER = "resourceServerConfigurerAdapter";

	/**
	 * 用户信息
	 */
	String DETAILS_USER = "user_info";

	/**
	 * 协议字段
	 */
	String DETAILS_LICENSE = "license";

	/**
	 * 验证码有效期,默认 60秒
	 */
	long CODE_TIME = 60;

	/**
	 * 验证码长度
	 */
	String CODE_SIZE = "6";

	/**
	 * 客户端模式
	 */
	String CLIENT_CREDENTIALS = "client_credentials";

	/**
	 * 客户端ID
	 */
	String CLIENT_ID = "clientId";


	/**
	 * @Author: huyc
	 * @Date: 2023/7/28
	 * @Description:  企业微信获取access_token
	 * @return:
	 **/
	String WX_GET_ACCOSS_TOKEN="https://qyapi.weixin.qq.com/cgi-bin/gettoken?corpid=%s&corpsecret=%s";

	/**
	 * @Author: huyc
	 * @Date: 2023/7/28
	 * @Description: 企业微信发送消息
	 * @return:
	 **/
	String WX_SEND_MESSAGE = "https://qyapi.weixin.qq.com/cgi-bin/message/send?access_token=%s";

	/**
	 * @Author: huyc
	 * @Date: 2023/7/28
	 * @Description: 企业微信发送消息授权路径
	 * @return:
	 * 下面链接中的state参数是和前端进行交互区分的重要参数，如果新增，请不要和以前的前缀相同
	 * 第一位标识消息类型：0审批，1抄送
	 * 第二位标识实体标识：1不购买商险申请
	 * 01 : 不购买商险申请审批
	 **/
	String WX_GET_MESSAGE_AUTH_URL = "https://open.weixin.qq.com/connect/oauth2/authorize?appid=%s&redirect_uri=%s&response_type=code&scope=snsapi_base&state=%s#wechat_redirect";

	// 获取审批单号list hgw 2024-4-12 14:45:25
	String WX_GET_APPROVAL_LIST = "https://qyapi.weixin.qq.com/cgi-bin/oa/getapprovalinfo?access_token={1}";
	// 获取审核详情
	String WX_GET_APPROVAL_DETAIL = "https://qyapi.weixin.qq.com/cgi-bin/oa/getapprovaldetail?access_token={1}";

	/**
	 * @Author: wangan
	 * @Date: 2020/7/29
	 * @Description:  企业微信获取企业的jsapi_ticket 用于签名
	 * @return:
	 **/
	String WX_JSAPI_TICKET_URL = "https://qyapi.weixin.qq.com/cgi-bin/get_jsapi_ticket?access_token=%s";
	/**
	 * @Author: wangdayu
	 * @Date: 2024/3/25
	 * @Description: 判断是否在应用可见范围内
	 * @return:
	 **/
	String WX_IS_IN_VISIBLE_RANGE= "https://qyapi.weixin.qq.com/cgi-bin/user/get?access_token=%s&userid=%s";
	/**
	 * 微信小程序
	 * @Author pwang
	 * @Date 2021-07-23 16:33
	 * @param null
	 * @return
	 **/
	String WX_APPLETS_KEY = "applets";

	/**
	 * @Author: pwang
	 * @Date: 2021/7/23
	 * @Description: 企业微信小程序获取用户userId
	 * @return:
	 **/
	String WX_APPLETS_GET_USER_ID = "https://qyapi.weixin.qq.com/cgi-bin/miniprogram/jscode2session?access_token={1}&js_code={2}&grant_type=authorization_code";

	/**
	 * @Author: wangan
	 * @Date: 2020/7/29
	 * @Description: 企业微信获取用户userId
	 * @return:
	 **/
	String WX_GET_USER_ID = "https://qyapi.weixin.qq.com/cgi-bin/user/getuserinfo?access_token={1}&code={2}";
}
