package com.yifu.cloud.plus.v1.yifu.common.core.util;

import com.alibaba.excel.converters.Converter;
import com.alibaba.excel.converters.WriteConverterContext;
import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.metadata.GlobalConfiguration;
import com.alibaba.excel.metadata.data.ReadCellData;
import com.alibaba.excel.metadata.data.WriteCellData;
import com.alibaba.excel.metadata.property.ExcelContentProperty;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.CommonConstants;

import java.util.Map;

/**
 * @Author fxj
 * @Date 2022/11/24
 * @Description
 * @Version 1.0
 */
public class DictConverter implements Converter<String>{
	public DictConverter(Map<String,String> nameAndDicTypeMap,Map<String,String> redisLabelMap){
		this.nameAndDicTypeMap=nameAndDicTypeMap;
		this.redisLabelMap=redisLabelMap;
	}
	private Map<String,String> nameAndDicTypeMap;

	private Map<String,String> redisLabelMap;

	@Override
	public Class<String> supportJavaTypeKey() {
		return String.class;
	}

	@Override
	public CellDataTypeEnum supportExcelTypeKey() {
		return CellDataTypeEnum.STRING;
	}
	/**
	 * @Author fxj
	 * @Description  转换成功java  导入用
	 * @Date 18:24 2022/11/24
	**/
	@Override
	public String convertToJavaData(ReadCellData cellData, ExcelContentProperty contentProperty
			, GlobalConfiguration globalConfiguration) {
		return cellData.getStringValue();
	}
	/**
	 * @Author fxj
	 * @Description  装换成String  导出用
	 * @Date 18:25 2022/11/24
	**/
	@Override
	public WriteCellData<String> convertToExcelData(String value, ExcelContentProperty contentProperty
			, GlobalConfiguration globalConfiguration) {
		if (null != nameAndDicTypeMap && nameAndDicTypeMap.size() > 0){
			String dicType = nameAndDicTypeMap.get(contentProperty.getField().getName());
			if (null != dicType){
				String temp =redisLabelMap.get(dicType+CommonConstants.DOWN_LINE_STRING+value);
				return new WriteCellData<>(null==temp?value:temp);
			}
		}
		return new WriteCellData<>(String.valueOf(value));
	}
	@Override
	public WriteCellData<?> convertToExcelData(WriteConverterContext<String> context) throws Exception {
		return this.convertToExcelData(context.getValue(), context.getContentProperty(), context.getWriteContext().currentWriteHolder().globalConfiguration());
	}
}
