package com.yifu.cloud.plus.v1.yifu.common.core.util;

import org.springframework.web.client.RestTemplate;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * @Author fxj
 * @Date 2024/5/8
 * @Description 年度法定节假日、公休日查询接口地址
 * @Version 1.0
 */
public class HolidayCrawler {
	/**
	 * 年度法定节假日、公休日查询接口地址
	 */
	private static final String YEAR_HOLIDAY_URL = "https://api.apihubs.cn/holiday/get?field=date,weekend&year="+DateUtil.getYear(new Date())+"&workday=2&order_by=1&cn=1&page=1&size=500";
	/**
	 * http请求工具类
	 */
	private static final RestTemplate REST_TEMPLATE = new RestTemplate();

	public static List<Map<String,Object>> initHolidays(){
		long ts = System.currentTimeMillis();
		Map<String,Object> result = REST_TEMPLATE.getForObject(String.format(YEAR_HOLIDAY_URL, ts, ts), Map.class);
		if(null!=result){
			String code=String.valueOf(result.get("code"));
			String msg=String.valueOf(result.get("msg"));
			if(code.equals("0") && msg.equals("ok")){
				Map data= (Map) result.get("data");
				if(null!=data){
					List<Map<String,Object>> list= (List<Map<String, Object>>) data.get("list");
					return  list;
					/*int i=0;
					for(Map<String,Object> d:list){
						System.out.println("i="+(++i)+"  日期="+d.get("date")+"    类型="+d.get("weekend")+"  weekend_cn="+d.get("weekend_cn"));
					}*/
				}
			}
		}
		return null;
	}
}
