package com.yifu.cloud.plus.v1.yifu.common.dapr.config;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.PropertySource;
import org.springframework.stereotype.Component;


/**
 * @author licancan
 * @description 商险模块dapr属性
 * @date 2022-08-03 10:25:48
 */
@Data
@Component
@PropertySource("classpath:daprConfig.properties")
@ConfigurationProperties(value = "dapr.insurances", ignoreInvalidFields = false)
public class DaprInsurancesProperties {

	/**
	 * dapr sidercar url  如：http://localhost:3511/v1.0/invoke/
	 */
	String appUrl;

	/**
	 * app_id  如："yifu_insurances_sider"
	 */
	String appId;

}
