package com.yifu.cloud.plus.v1.yifu.common.dapr.util;

import com.yifu.cloud.plus.v1.yifu.admin.api.entity.SysDataAuth;
import com.yifu.cloud.plus.v1.yifu.archives.vo.TSettleDomainListVo;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.CacheConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.CommonConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.SecurityConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.util.Common;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.YifuUser;
import com.yifu.cloud.plus.v1.yifu.common.dapr.config.DaprArchivesProperties;
import com.yifu.cloud.plus.v1.yifu.common.dapr.config.DaprUpmsProperties;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.cache.support.SimpleValueWrapper;

/**
 * @author hgw
 * 2022-9-13 16:14:34
 * @Description 公共获取菜单权限的工具
 */
@EnableConfigurationProperties({DaprUpmsProperties.class,DaprArchivesProperties.class})
@RequiredArgsConstructor
@Slf4j
public class MenuUtil {
	// 缓存信息
	private final CacheManager cacheManager;

	private final DaprUpmsProperties daprUpmsProperties;
	private final DaprArchivesProperties daprArchivesProperties;
	private static final String START_STR = "start";

	public void setAuthSql(YifuUser user, BaseEntity entity) {
		// 普通用户：
		if (user != null && Common.isNotNull(user.getId()) && CommonConstants.ONE_STRING.equals(user.getSystemFlag())) {
			// 菜单id
			String menuId = entity.getMId();
			if (Common.isEmpty(menuId)) {
				menuId = entity.getMenuInfo();
			}
			if (Common.isNotNull(menuId)) {
				String linkId = user.getId();
				int linkType = 1; // 用户
				SysDataAuth sysDataAuth = new SysDataAuth();
				sysDataAuth.setLinkId(linkId);
				sysDataAuth.setLinkType(linkType);
				// 获取缓存菜单权限的步骤：
				Cache cache = cacheManager.getCache(CacheConstants.DATA_AUTH_DETAILS + linkType);
				Object obj = null;
				if (cache != null) {
					obj = cache.get(linkId + CommonConstants.DOWN_LINE_STRING + menuId);
					if (Common.isEmpty(obj)) {
						HttpDaprUtil.invokeMethodPost(daprUpmsProperties.getAppUrl(), daprUpmsProperties.getAppId()
								, "/dataAuth/refreshAuth", sysDataAuth, SysDataAuth.class, SecurityConstants.FROM_IN);
						obj = cache.get(linkId + CommonConstants.DOWN_LINE_STRING + menuId);
						if (Common.isEmpty(obj)) {
							linkId = user.getUserGroup();
							linkType = 0; // 用户组
							cache = cacheManager.getCache(CacheConstants.DATA_AUTH_DETAILS + linkType);
							if (cache != null) {
								obj = cache.get(linkId + CommonConstants.DOWN_LINE_STRING + menuId);
								if (Common.isEmpty(obj)) {
									sysDataAuth.setLinkId(linkId);
									sysDataAuth.setLinkType(linkType);
									HttpDaprUtil.invokeMethodPost(daprUpmsProperties.getAppUrl(), daprUpmsProperties.getAppId()
											, "/dataAuth/refreshAuth", sysDataAuth, SysDataAuth.class, SecurityConstants.FROM_IN);
									obj = cache.get(linkId + CommonConstants.DOWN_LINE_STRING + menuId);
								}
							}
						}
					}
				}
				if (Common.isNotNull(obj)) {
					SimpleValueWrapper objs = (SimpleValueWrapper) obj;
					if (Common.isNotNull(objs)) {
						String sql = String.valueOf(objs.get());
						if (sql.contains("#create_by")) {
							sql = sql.replace("#create_by", user.getId());
						}
						if (sql.contains("#settleDomainId")) {
							// 获取人员项目权限
							R<TSettleDomainListVo> res = HttpDaprUtil.invokeMethodPost(daprArchivesProperties.getAppUrl()
									, daprArchivesProperties.getAppId(),"/tsettledomain/getSettleDomainIdsByUserId"
									, user.getId(), TSettleDomainListVo.class, SecurityConstants.FROM_IN);
							StringBuilder deptStr = new StringBuilder();
							if (res != null && CommonConstants.SUCCESS == res.getCode()
									&& res.getData() != null && res.getData().getDeptIds() != null
									&& !res.getData().getDeptIds().isEmpty()) {
								for (String deptId : res.getData().getDeptIds()) {
									deptStr.append(",'").append(deptId).append("'");
								}
							}
							//sql = sql.replace("or a.settle_domain_id in ('0'#settleDomainId) ", "")
							sql = sql.replace("#settleDomainId", deptStr.toString());
						}
						String userIds = "0";
						if (sql.contains(START_STR)) {
							String deptIds = StringUtils.substringBetween(sql,START_STR, "end");
							R<String> userIdR = HttpDaprUtil.invokeMethodPost(daprUpmsProperties.getAppUrl()
									,daprUpmsProperties.getAppId(),"/user/inner/getUserIdByDeptIds",deptIds
									, String.class, SecurityConstants.FROM_IN);
							if (userIdR != null && CommonConstants.SUCCESS == userIdR.getCode()) {
								userIds = userIdR.getData();
							}
							sql = sql.replace(START_STR, "").replace("end", "")
									.replace(deptIds, userIds);
						}
						if (sql.contains("#deptId")) {
							R<String> userIdR = HttpDaprUtil.invokeMethodPost(daprUpmsProperties.getAppUrl()
									,daprUpmsProperties.getAppId(),"/user/inner/getUserIdByDeptIds"
									,String.valueOf(user.getDeptId()), String.class, SecurityConstants.FROM_IN);
							if (userIdR != null && CommonConstants.SUCCESS == userIdR.getCode()) {
								userIds = userIdR.getData();
							}
							sql = sql.replace("#deptId", userIds);
							//sql = sql.replace(" or dept.dept_id = #deptId ", "")
						}
						if (Common.isNotNull(sql)) {
							entity.setAuthSql(sql);
						}
					}
				}
			}
		}
	}
}
