package com.yifu.cloud.plus.v1.yifu.common.dapr.util;

import com.yifu.cloud.plus.v1.yifu.common.core.constant.SecurityConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.util.Common;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.dapr.config.DaprProcessProperties;
import com.yifu.cloud.plus.v1.yifu.process.vo.ProcessVo;
import lombok.extern.log4j.Log4j2;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;

/**
 * 流程
 * @author chenyuxi
 * @date 2025-01-10 17:47:32
 * @since 1.7.5
 */
@Log4j2
@EnableConfigurationProperties(DaprProcessProperties.class)
public class ProcessDaprUtils {

	@Autowired
	private DaprProcessProperties daprProcessProperties;

	/**
	 * 根据流程类型查询ProcessVo
	 * @param processType 流程类型
	 * @return R<ProcessVo>
	 * @since mvp1.7.5
	 **/
	public R<ProcessVo> getProcessVoByType(String processType) {
		R<ProcessVo> processVoR = HttpDaprUtil.invokeMethodPost(daprProcessProperties.getAppUrl(),daprProcessProperties.getAppId(),"/tprocess/inner/getProcessVoByType", processType, ProcessVo.class, SecurityConstants.FROM_IN);
		if (Common.isEmpty(processVoR)){
			return R.failed("根据流程类型查询ProcessVo失败！");
		}
		return processVoR;
	}

	/**
	 * 根据流程Id查询ProcessVo
	 * @param processId 流程ID
	 * @return R<ProcessVo>
	 * @since mvp1.7.5
	 **/
	public R<ProcessVo> getProcessVoById(String processId) {
		R<ProcessVo> processVoR = HttpDaprUtil.invokeMethodPost(daprProcessProperties.getAppUrl(),daprProcessProperties.getAppId(),"/tprocess/inner/getProcessVoByProcessId", processId, ProcessVo.class, SecurityConstants.FROM_IN);
		if (Common.isEmpty(processVoR)){
			return R.failed("根据流程ID查询ProcessVo失败！");
		}
		return processVoR;
	}

}
