package com.yifu.cloud.plus.v1.yifu.process.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.util.ArrayList;
import java.util.List;


/**
 * 流程节点表
 *
 * @author hgw
 * @date 2020-07-16 15:44:02
 */
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("t_process_node")
@Schema(description = "流程节点表")
public class TProcessNode extends Model<TProcessNode> {
     private static final long serialVersionUID = 1L;

     @TableId(type = IdType.ASSIGN_ID)
	 @Schema(description = "主键")
     private String id;
     /**
      * 类型：{
      * begin：开始
      * end：结束
      * cancel：取消
      * choice：选择
      * split：拆分
      * parallel：并行
      * merge：合并
      * embed：流程调用
      * delay：定时
      * invoke：服务调用
      * service：服务
      * agent：脚本
      * }
      */
     @NotBlank(message = "类型：不能为空")
     @Length(max = 20, message = "类型：不能超过20个字符")
	 @Schema(description = "类型")
     private String type;

     @NotBlank(message = "标识（自动生成MD5串）不能为空")
     @Length(max = 255, message = "标识（自动生成MD5串）不能超过255个字符")
	 @Schema(description = "标识（自动生成MD5串）")
     private String logoTitle;

     @NotBlank(message = "节点名称不能为空")
     @Length(max = 255, message = "节点名称不能超过255个字符")
	 @Schema(description = "节点名称")
     private String name;

     @Length(max = 255, message = "节点描述不能超过255个字符")
	 @Schema(description = "节点描述")
     private String description;

     @Length(max = 255, message = "表单ID不能超过255个字符")
	 @Schema(description = "表单ID", name = "form")
     private String form;

     @NotBlank(message = "是否允许调度（0是/1否）不能为空")
     @Length(max = 1, message = "是否允许调度（0是/1否）不能超过1个字符")
	 @Schema(description = "是否允许调度（0是/1否）")
     private String allowDispatch;

     @NotBlank(message = "是否允许调度到此活动不能为空")
     @Length(max = 1, message = "是否允许调度到此活动不能超过1个字符")
	 @Schema(description = "是否允许调度到此活动")
     private String allowThis;

     @NotBlank(message = "流程ID不能为空")
     @Length(max = 255, message = "流程ID不能超过255个字符")
	 @Schema(description = "流程ID")
     private String processId;

     @NotBlank(message = "经办人是否允许办理完成后进入下一步（0允许/1不允许）不能为空")
     @Length(max = 1, message = "经办人是否允许办理完成后进入下一步（0允许/1不允许）不能超过1个字符")
	 @Schema(description = "经办人是否允许办理完成后进入下一步（0允许/1不允许）")
     private String handleAllowNext;

     @NotBlank(message = "会签方式（0允许会签/1强制会签/2禁止会签）不能为空")
     @Length(max = 1, message = "会签方式（0允许会签/1强制会签/2禁止会签）不能超过1个字符")
     @Schema(description = "会签方式（0允许会签/1强制会签/2禁止会签）")
     private String countersign;

     @NotBlank(message = "回退方式（0不允许/1回退上一步/2回退至起点）不能为空")
     @Length(max = 1, message = "回退方式（0不允许/1回退上一步/2回退至起点）不能超过1个字符")
	 @Schema(description = "回退方式（0不允许/1回退上一步/2回退至起点）")
     private String backType;

     @Length(max = 100, message = "元素的图形：不能超过100个字符")
	 @Schema(description = "元素的图形")
     private String shape;

     @Length(max = 100, message = "节点大小：不能超过100个字符")
	 @Schema(description = "节点大小")
     private String size;

     @Length(max = 20, message = "X坐标：不能超过20个字符")
	 @Schema(description = "X坐标")
     private String coordinatex;

     @Length(max = 20, message = "Y坐标：不能超过20个字符")
	 @Schema(description = "Y坐标")
     private String coordinatey;

     @Length(max = 50, message = "颜色：不能超过50个字符")
	 @Schema(description = "颜色")
     private String color;

     @TableField(exist = false)
     private List<TNodePrimission> nodePrimissionList = new ArrayList<>();

     @TableField(exist = false)
     private List<TNodeReaderPromission> nodeReaderPromissionList = new ArrayList<>();

     @TableField(exist = false)
     private List<TNodeTransferConfig> nodeTransferConfigs;

	 @Schema(description = "允许加签")
     private String allowAddSign;

     /**
      * 节点抄送权限列表（流程预览使用，将当前节点的抄送权限绑定在下一个节点上，因为当前的代码逻辑不返回抄送节点，有冲突）
      * 【之后优化@TableField注解，不能在实体类里面直接用@TableField，要建一个包装类】
      */
     @TableField(exist = false)
     private List<TNodeReaderPromission> preNodeReaderPromissionList = new ArrayList<>();
}
