package com.yifu.cloud.plus.v1.yifu.common.swagger.config;


import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.enums.SecuritySchemeIn;
import io.swagger.v3.oas.annotations.enums.SecuritySchemeType;
import io.swagger.v3.oas.annotations.info.Contact;
import io.swagger.v3.oas.annotations.info.Info;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.security.SecurityScheme;
import org.springframework.context.annotation.Configuration;

/**
 * @author fxj * @date 2022年05月31日 17:29 @description
 */
@OpenAPIDefinition(
		info = @Info(
				title = "Swagger3",
				version = "1.0",
				description = "Swagger3使用演示",
				contact = @Contact(name = "fxj")
		),
		security = @SecurityRequirement(name = "JWT"),
		externalDocs = @ExternalDocumentation(description = "参考文档",
				url = "https://github.com/swagger-api/swagger-core/wiki/Swagger-2.X---Annotations"
		)
)
@SecurityScheme(type = SecuritySchemeType.HTTP, name = "JWT", scheme = "bearer", in = SecuritySchemeIn.HEADER)
@Configuration
//@SecurityScheme(type = SecuritySchemeType.OAUTH2,flows = @OAuthFlow( implicit = @OAuthFlow(authorizationUrl = "http://yifu-auth/oauth/check_token",
//		scopes = @OAuthScope(name = "write:pets", description = "modify pets in your account"))))
public class Swagger3Config {

}
