/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.csp.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.csp.entity.TOperationLog;
import com.yifu.cloud.plus.v1.csp.service.TOperationLogService;
import com.yifu.cloud.plus.v1.csp.vo.TOperationLogSearchVo;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.*;

import java.util.List;


/**
 * 入离职等的操作日志
 *
 * @author hgw
 * @date 2025-02-28 15:18:43
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/toperationlog")
@Tag(name = "入离职等的操作日志管理")
public class TOperationLogController {

	private final TOperationLogService tOperationLogService;


	/**
	 * 简单分页查询
	 *
	 * @param page          分页对象
	 * @param tOperationLog 入离职等的操作日志
	 * @return
	 */
	@Operation(description = "简单分页查询")
	@GetMapping("/page")
	public R<IPage<TOperationLog>> getTOperationLogPage(Page<TOperationLog> page, TOperationLogSearchVo tOperationLog) {
		return new R<>(tOperationLogService.getTOperationLogPage(page, tOperationLog));
	}

	/**
	 * 不分页查询
	 *
	 * @param tOperationLog 入离职等的操作日志
	 * @return
	 */
	@Operation(summary = "不分页查询", description = "不分页查询")
	@PostMapping("/noPage")
	public R<List<TOperationLog>> getTOperationLogNoPage(@RequestBody TOperationLogSearchVo tOperationLog) {
		return R.ok(tOperationLogService.noPageDiy(tOperationLog));
	}

	/**
	 * 通过id查询入离职等的操作日志
	 *
	 * @param id id
	 * @return R
	 */
	@Operation(summary = "通过id查询", description = "通过id查询")
	@GetMapping("/{id}")
	public R<TOperationLog> getById(@PathVariable("id") String id) {
		return R.ok(tOperationLogService.getById(id));
	}

}
