/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.ekp.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.yifu.cloud.plus.v1.ekp.entity.EkpBankGrantDetail;
import com.yifu.cloud.plus.v1.ekp.vo.EkpBankCodeConfiglVo;
import com.yifu.cloud.plus.v1.ekp.vo.EkpBankExcelVo;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 发放结果明细(银企付款任务)
 *
 * @author hgw
 * @date 2024-11-15 17:12:14
 */
@Mapper
public interface EkpBankGrantDetailMapper extends BaseMapper<EkpBankGrantDetail> {

	// 查询待发放条数
	int getCountByIdAndMain(@Param("fdParentId") String fdParentId);
	// 查询主表下的全部数据
	List<EkpBankExcelVo> getEkpBankExcelVoByIdAndMain(@Param("fdParentId") String fdParentId);

	// 查询详情里的1条数据
	List<EkpBankExcelVo> getEkpBankExcelVoByIdAndDetail(@Param("fdId") String fdId);

	// 编号查重
	String getWxNoByWxNo(@Param("wxNo") String wxNo);

	// 主表发放时，更新明细表的发放时间与状态
	void updateStatusByGrant(@Param("fdParentId") String fdParentId);

	// 主表拒绝授权时，批量更新明细表为发放失败，原因为拒绝授权
	void updateStatusByGrantFail(@Param("fdParentId") String fdParentId);

	// 发放失败，批量更新中信银行交易流水表fd_3b148bc0c28e48为失败，根据 工资明细fdId：fd_3b1fe00b0f5dde
	void updateZhongXinStatus(@Param("salaryId") String salaryId, @Param("detailId") String detailId, @Param("detailFailMsg") String detailFailMsg);
	// 发放失败，批量更新中信银行交易流水Model表fd_3b148bc0c28e48为失败，根据 工资明细fdId：fd_3b1fe00b0f5dde
	void updateZhongXinMainStatus(@Param("salaryId") String salaryId, @Param("detailId") String detailId, @Param("detailFailMsg") String detailFailMsg);

	// 发放失败，批量更新中信银行交易流水表fd_3b148bc0c28e48为失败，根据 工资明细fdId：fd_3b1fe00b0f5dde
	void updateZhongXinStatusAndBankInfo(@Param("salaryIdList") List<String> salaryIdList);
	// 发放失败，批量更新中信银行交易流水Model表fd_3b148bc0c28e48为失败，根据 工资明细fdId：fd_3b1fe00b0f5dde
	void updateZhongXinMainStatusAndBankInfo(@Param("salaryIdList") List<String> salaryIdList);

	// 获取明细表ID来更新状态
	List<EkpBankGrantDetail> getListByParentId(@Param("fdParentId") String fdParentId);

	/**
	 * @Description: 获取工行开户行配置表
	 * @Author: hgw
	 * @Date: 2024/12/25 16:05
	 * @return: java.util.List<com.yifu.cloud.plus.v1.ekp.vo.EkpBankCodeConfiglVo>
	 **/
	List<EkpBankCodeConfiglVo> getEkpBankCodeConfiglVo();

	// 更新工资支出的 银企出纳
	void updateGongZiZhiChuTable(@Param("fdId") String fdId, @Param("chuNaName") String chuNaName);
	// 更新工资支出Main表的 银企出纳
	void updateGongZiZhiChuMain(@Param("fdId") String fdId, @Param("chuNaName") String chuNaName);

}
