package com.yifu.cloud.plus.v1.ekp.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yifu.cloud.plus.v1.ekp.entity.EkpFundInfo;
import com.yifu.cloud.plus.v1.ekp.mapper.EkpFundInfoMapper;
import com.yifu.cloud.plus.v1.ekp.service.EkpFundInfoService;
import com.yifu.cloud.plus.v1.ekp.vo.EkpDeptInfoVo;
import com.yifu.cloud.plus.v1.ekp.vo.EkpSocialPushInfoVo;
import com.yifu.cloud.plus.v1.ekp.vo.EkpSocialSumInfoVo;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.CommonConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.util.BigDecimalUtils;
import com.yifu.cloud.plus.v1.yifu.common.core.util.Common;
import com.yifu.cloud.plus.v1.yifu.common.core.util.DateUtil;
import com.yifu.cloud.plus.v1.yifu.common.core.util.LocalDateTimeUtils;
import com.yifu.cloud.plus.v1.yifu.ekp.vo.EkpPushFundParam;
import lombok.extern.log4j.Log4j2;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.*;
import java.util.stream.Collectors;

/**
//社保明细表
 *
//@author huyc
//@date 2024-02-29 11:21:56
 */
@Log4j2
@Service
public class EkpFundInfoServiceImpl extends ServiceImpl<EkpFundInfoMapper, EkpFundInfo> implements EkpFundInfoService {

	/**
	 //@Description: 公积金明细推送至ekp
	 //@Author: huyc
	 //@Date: 2024-2-29
	 //@return: void
	 **/
	@Override
	public EkpSocialPushInfoVo pushFundInfoToEkp(List<EkpPushFundParam> unPushList) {

		//插入数据集合
		List<EkpFundInfo> fundInfoList = new ArrayList<>();
		//社保id集合 用于更新社保状态
		List<String> paymentIds = new ArrayList<>();

		//获取ekp所有项目信息
		List<EkpDeptInfoVo> deptInfoVoList = baseMapper.getAllEkpDeptInfo();
		Map<String, EkpDeptInfoVo> map = new HashMap<>();
		EkpDeptInfoVo deptInfo;
		EkpSocialSumInfoVo socialSumInfo;
		if (Optional.ofNullable(deptInfoVoList).isPresent()) {
			map = deptInfoVoList.stream().collect(Collectors.toMap(EkpDeptInfoVo::getDeptNo, k -> k));
		}
		long fundCount;
		try {
			for (EkpPushFundParam fundParam : unPushList) {
				//去重 防止重复推送
				fundCount = baseMapper.getFundCount(fundParam.getFd_3b0afbaf10df2c());
				if (fundCount > 0) {
					continue;
				}
				EkpFundInfo fundInfo = new EkpFundInfo();
				//对象信息赋值
				copyFundProperties(fundParam, fundInfo);

				//项目信息
				deptInfo = map.get(fundInfo.getFd_3adfe8c70d3fd4());
				if (Common.isEmpty(deptInfo)) {
					continue;
				}
				fundInfo.setFd_3b16e37baa5650_text(deptInfo.getDeptName());
				fundInfo.setFd_3b16e37baa5650(deptInfo.getFdId());
				//实际结算月份
				if ("生成月本月数据".equals(deptInfo.getSocialType())) {
					fundInfo.setFd_3adfe8cff746bc(dateStringInsert(fundInfo.getFd_3adfe8cb96c41e()));
				} else if ("生成月上月数据".equals(deptInfo.getSocialType())) {
					fundInfo.setFd_3adfe8cff746bc(DateUtil.dateToString(DateUtil.addMonthByDate(DateUtil.parseDate(fundInfo.getFd_3adfe8cb96c41e(), "yyyyMM"), -1), "yyyy-MM"));
				} else if ("生成月次月数据".equals(deptInfo.getSocialType())) {
					fundInfo.setFd_3adfe8cff746bc(DateUtil.dateToString(DateUtil.addMonthByDate(DateUtil.parseDate(fundInfo.getFd_3adfe8cb96c41e(), "yyyyMM"), 1), "yyyy-MM"));
				} else {
					fundInfo.setFd_3adfe8cff746bc("");
				}
				//是否全部结算
				if ("全量未结算数据".equals(deptInfo.getSocialType())) {
					fundInfo.setFd_3b13afd1ef7798(CommonConstants.IS_TRUE);
				} else {
					fundInfo.setFd_3b13afd1ef7798(CommonConstants.IS_FALSE);
				}
				fundInfo.setFd_3adfe8cb96c41e(dateStringInsert(fundInfo.getFd_3adfe8cb96c41e()));
				//获取社保订单明细合计
				socialSumInfo = baseMapper.getCostSumInfo(fundInfo.getFd_3adfe8c7e4cf7a(), fundInfo.getFd_3adfe8cb96c41e());

				//预估个人合计
				BigDecimal ygPersonSum = Common.isEmpty(socialSumInfo) ? BigDecimal.ZERO : BigDecimal.valueOf(socialSumInfo.getYgPersonSum());
				//预估单位合计
				BigDecimal ygDwSum = Common.isEmpty(socialSumInfo) ? BigDecimal.ZERO : BigDecimal.valueOf(socialSumInfo.getYgDwSum());
				//实缴单位合计
				BigDecimal sjDwSum = Common.isEmpty(socialSumInfo) ? BigDecimal.ZERO : BigDecimal.valueOf(socialSumInfo.getSjDwSum());
				//实缴个人合计
				BigDecimal sjPersonSum = Common.isEmpty(socialSumInfo) ? BigDecimal.ZERO : BigDecimal.valueOf(socialSumInfo.getSjPersonSum());
				//应收
				BigDecimal ys = Common.isEmpty(socialSumInfo) ? BigDecimal.ZERO : BigDecimal.valueOf(socialSumInfo.getYs());
				//个人应收
				BigDecimal personYs = Common.isEmpty(socialSumInfo) ? BigDecimal.ZERO : BigDecimal.valueOf(socialSumInfo.getPersonYs());
				//单位应收
				BigDecimal dwYs = Common.isEmpty(socialSumInfo) ? BigDecimal.ZERO : BigDecimal.valueOf(socialSumInfo.getDwYs());

				//预估个人部分
				BigDecimal yggr = Common.isEmpty(fundInfo.getFd_3adfeb52a4d2e2()) ? BigDecimal.ZERO : BigDecimal.valueOf(fundInfo.getFd_3adfeb52a4d2e2());
				//预估单位部分
				BigDecimal ygdw = Common.isEmpty(fundInfo.getFd_3adfeb4e8064a8()) ? BigDecimal.ZERO : BigDecimal.valueOf(fundInfo.getFd_3adfeb4e8064a8());
				//实缴单位部分
				BigDecimal sjdw = Common.isEmpty(fundInfo.getFd_3adfeb52fbe966()) ? BigDecimal.ZERO : BigDecimal.valueOf(fundInfo.getFd_3adfeb52fbe966());
				//实缴个人部分
				BigDecimal sjgr = Common.isEmpty(fundInfo.getFd_3adfeb5366dd82()) ? BigDecimal.ZERO : BigDecimal.valueOf(fundInfo.getFd_3adfeb5366dd82());
				//单位差异
				if ("是".equals(fundInfo.getFd_3add9de0be85e4()) && "实缴".equals(fundInfo.getFd_3add9dd7833db8())) {
					//单位差异
					//$列表.求总和$($公积金订单明细*总数(单位代缴)$)+$单位代缴$) -($列表.求总和$($公积金订单明细*总数(预估单位代缴)$) + $预估单位代缴$)
					fundInfo.setFd_3adfeb53c70f72(BigDecimalUtils.safeSubtract(false,BigDecimalUtils.safeAdd(sjDwSum,sjdw),BigDecimalUtils.safeAdd(ygDwSum,yggr)).doubleValue());
					//个人差异
					//$列表.求总和$($公积金订单明细*总数(个人代缴)$)+ $个人代缴$  - $列表.求总和$($公积金订单明细*总数(预估个人代缴)$)
					fundInfo.setFd_3adfeb5413fb44(BigDecimalUtils.safeSubtract(false,BigDecimalUtils.safeAdd(sjPersonSum,sjgr),ygPersonSum).doubleValue());
				}

				//Fd_3adfeb7b624f06应收；Fd_3b35a65138a7fc个人应收；fd_3b35a6518b73b2单位应收
				if ("是".equals(deptInfo.getIsBpo())) {
					//应收
					fundInfo.setFd_3adfeb7b624f06(CommonConstants.ZERO_INTEGER.doubleValue());
					//个人应收
					fundInfo.setFd_3b35a65138a7fc(CommonConstants.ZERO_INTEGER.doubleValue());
					//单位应收
					fundInfo.setFd_3b35a6518b73b2(CommonConstants.ZERO_INTEGER.doubleValue());
				} else {
					if ("实缴".equals(deptInfo.getSettleType())) {
						if ("预估".equals(fundInfo.getFd_3add9dd7833db8())) {
							//$列表.求总和$($公积金订单明细*总数(预估单位代缴)$)  + $列表.求总和$($公积金订单明细*总数(预估个人代缴)$)  + $预估个人代缴$ + $预估单位代缴$ - $列表.求总和$($公积金订单明细*总数(应收)$)
							fundInfo.setFd_3adfeb7b624f06(BigDecimalUtils.safeSubtract(false,BigDecimalUtils.safeAdd(ygDwSum,ygPersonSum,yggr,ygdw),ys).doubleValue());
							//$列表.求总和$($公积金订单明细*总数(预估个人代缴)$)  + $预估个人代缴$  - $列表.求总和$($公积金订单明细*总数(个人应收)$)
							fundInfo.setFd_3b35a65138a7fc(BigDecimalUtils.safeSubtract(false,BigDecimalUtils.safeAdd(ygPersonSum, yggr),personYs).doubleValue());
							//$列表.求总和$($公积金订单明细*总数(预估单位代缴)$)  + $预估单位代缴$ - $列表.求总和$($公积金订单明细*总数(单位应收)$)
							fundInfo.setFd_3b35a6518b73b2(BigDecimalUtils.safeSubtract(false,BigDecimalUtils.safeAdd(ygDwSum, ygdw),dwYs).doubleValue());
						} else {
							if (BigDecimalUtils.safeAdd(ygDwSum, ygPersonSum).doubleValue() > 0) {
								//应收
								fundInfo.setFd_3adfeb7b624f06(CommonConstants.ZERO_INTEGER.doubleValue());
								//个人应收
								fundInfo.setFd_3b35a65138a7fc(CommonConstants.ZERO_INTEGER.doubleValue());
								//单位应收
								fundInfo.setFd_3b35a6518b73b2(CommonConstants.ZERO_INTEGER.doubleValue());
							} else {
								// $列表.求总和$($公积金订单明细*总数(单位代缴)$) +$列表.求总和$($公积金订单明细*总数(个人代缴)$) + $单位代缴$ + $个人代缴$ - $列表.求总和$($公积金订单明细*总数(应收)$)
								fundInfo.setFd_3adfeb7b624f06(BigDecimalUtils.safeSubtract(false,BigDecimalUtils.safeAdd(sjDwSum,sjPersonSum,sjdw,sjgr),ys).doubleValue());
								//$列表.求总和$($公积金订单明细*总数(个人代缴)$) +  $个人代缴$ - $列表.求总和$($公积金订单明细*总数(个人应收)$)
								fundInfo.setFd_3b35a65138a7fc(BigDecimalUtils.safeSubtract(false,BigDecimalUtils.safeAdd(sjPersonSum,sjgr),personYs).doubleValue());
								//$列表.求总和$($公积金订单明细*总数(单位代缴)$)  + $单位代缴$ - $列表.求总和$($公积金订单明细*总数(单位应收)$)
								fundInfo.setFd_3b35a6518b73b2(BigDecimalUtils.safeSubtract(false,BigDecimalUtils.safeAdd(sjDwSum,sjdw),dwYs).doubleValue());
							}
						}
					} else {
						if ("预估".equals(fundInfo.getFd_3add9dd7833db8())) {
							// $列表.求总和$($公积金订单明细*总数(预估个人代缴)$) + $列表.求总和$($公积金订单明细*总数(预估单位代缴)$)  + $预估个人代缴$ + $预估单位代缴$ -$列表.求总和$($公积金订单明细*总数(应收)$)
							fundInfo.setFd_3adfeb7b624f06(BigDecimalUtils.safeSubtract(false,BigDecimalUtils.safeAdd(ygPersonSum,ygDwSum,yggr,ygdw),ys).doubleValue());
							//$列表.求总和$($公积金订单明细*总数(预估个人代缴)$)  + $预估个人代缴$   -$列表.求总和$($公积金订单明细*总数(个人应收)$)
							fundInfo.setFd_3b35a65138a7fc(BigDecimalUtils.safeSubtract(false,BigDecimalUtils.safeAdd(ygPersonSum,yggr),personYs).doubleValue());
							// $列表.求总和$($公积金订单明细*总数(预估单位代缴)$)  + $预估单位代缴$ -$列表.求总和$($公积金订单明细*总数(单位应收)$)
							fundInfo.setFd_3b35a6518b73b2(BigDecimalUtils.safeSubtract(false,BigDecimalUtils.safeAdd(ygDwSum,ygdw),dwYs).doubleValue());
						} else {
							//$列表.求总和$($公积金订单明细*总数(单位代缴)$) +$列表.求总和$($公积金订单明细*总数(个人代缴)$) + $单位代缴$ + $个人代缴$ - $列表.求总和$($公积金订单明细*总数(应收)$)
							fundInfo.setFd_3adfeb7b624f06(BigDecimalUtils.safeSubtract(false,BigDecimalUtils.safeAdd(sjDwSum,sjPersonSum,sjdw,sjgr),ys).doubleValue());
							//$列表.求总和$($公积金订单明细*总数(个人代缴)$)  + $个人代缴$ - $列表.求总和$($公积金订单明细*总数(个人应收)$)
							fundInfo.setFd_3b35a65138a7fc(BigDecimalUtils.safeSubtract(false,BigDecimalUtils.safeAdd(sjPersonSum,sjgr),personYs).doubleValue());
							//$列表.求总和$($公积金订单明细*总数(单位代缴)$)  + $单位代缴$  - $列表.求总和$($公积金订单明细*总数(单位应收)$)
							fundInfo.setFd_3b35a6518b73b2(BigDecimalUtils.safeSubtract(false,BigDecimalUtils.safeAdd(sjDwSum,sjdw),dwYs).doubleValue());
						}
					}
				}

				if ("预估".equals(fundInfo.getFd_3add9dd7833db8())) {
					//应支出
					fundInfo.setFd_3adfeb7bd97464(CommonConstants.ZERO_INTEGER.doubleValue());
					//个人应支
					fundInfo.setFd_3b35a6989dfde8(CommonConstants.ZERO_INTEGER.doubleValue());
					//单位应支
					fundInfo.setFd_3b35a6992a20a4(CommonConstants.ZERO_INTEGER.doubleValue());
				} else {
					//应支出
					fundInfo.setFd_3adfeb7bd97464(Double.sum(fundInfo.getFd_3adfeb52fbe966(),fundInfo.getFd_3adfeb5366dd82()));
					//个人应支
					fundInfo.setFd_3b35a6989dfde8(fundInfo.getFd_3adfeb5366dd82());
					//单位应支
					fundInfo.setFd_3b35a6992a20a4(fundInfo.getFd_3adfeb52fbe966());
				}
				//创建时间
				fundInfo.setCreateTime(DateUtil.getCurrentDateTime());
				fundInfoList.add(fundInfo);
				paymentIds.add(fundParam.getFd_3b0afbaf10df2c());
			}
			if (!fundInfoList.isEmpty()) {
				boolean flag = this.saveBatch(fundInfoList);
				if (flag) {
					//推送成功更新明细状态
					EkpSocialPushInfoVo pushInfoVo = new EkpSocialPushInfoVo();
					pushInfoVo.setPaymentIds(paymentIds);
					return pushInfoVo;
				}
			}
		} catch (Exception e) {
			log.error("公积金明细推送失败",e);
			return null;
		}
		return null;
	}

	private void copyFundProperties(EkpPushFundParam socialParam,EkpFundInfo socialInfo) {
		//订单类型
		socialInfo.setFd_3add9dd7833db8(socialParam.getFd_3add9dd7833db8());
		//与工资合并结算
		socialInfo.setFd_3add9e1a670144(socialParam.getFd_3add9e1a670144());
		//是否有预估
		socialInfo.setFd_3add9de0be85e4(socialParam.getFd_3add9de0be85e4());
		//是否为BPO业务
		socialInfo.setFd_3b178ec510bf48(socialParam.getFd_3b178ea361cabe());
		//创建人姓名
		socialInfo.setFd_3b439246fcdc7c(socialParam.getFd_3b43922217c6f8());
		//项目编码
		socialInfo.setFd_3adfe8c70d3fd4(socialParam.getFd_3adfe8c70d3fd4());
		//项目名称
		socialInfo.setFd_3adfe8c8468e54(socialParam.getFd_3adfe8c8468e54());
		//项目编码-原  fxj 20240527 add
		socialInfo.setFd_3cfe2da7e35daa(socialParam.getFd_3adfe8c70d3fd4());
		//项目名称-原  fxj 20240527 add
		socialInfo.setFd_3cfe2db5015d6e(socialParam.getFd_3adfe8c8468e54());
		//单号
		socialInfo.setFd_3adfe95c169c48(socialParam.getFd_3adfe95c169c48());
		//客户编码
		socialInfo.setFd_3adfe8c73cb5a4(socialParam.getFd_3adfe8c73cb5a4());
		//客户名称
		socialInfo.setFd_3adfe8c81a0e42(socialParam.getFd_3adfe8c81a0e42());
		//公积金户
		socialInfo.setFd_3aeafa8cc144bc(socialParam.getFd_3aeafa8cc144bc());
		//姓名
		socialInfo.setFd_3adfe8c79989d4(socialParam.getFd_3adfe8c79989d4());
		//身份证号
		socialInfo.setFd_3adfe8c7e4cf7a(socialParam.getFd_3adfe8c7e4cf7a());
		//我司到款单位
		socialInfo.setFd_3b01956c77864c(socialParam.getFd_3b019a2e9bfdd6());
		//生成月份
		socialInfo.setFd_3adfe8cb96c41e(socialParam.getFd_3adfe8cb96c41e());
		//缴纳月份
		socialInfo.setFd_3adfe8cf632700(socialParam.getFd_3adfe8cf632700());
		//公积金ID
		socialInfo.setFd_3b10b38f90d138(socialParam.getFd_3b0afbaf10df2c());
		//薪酬申请编号
		socialInfo.setFd_3b3cabbf094f1a(socialParam.getFd_3b3cabde83d1d0());
		//缴纳地
		socialInfo.setFd_3b5cc4b2aae22a(socialParam.getFd_3b5cc487bb46fa());
		//预估单位部分
		socialInfo.setFd_3adfeb4e8064a8(CommonConstants.EMPTY_STRING.equals(socialParam.getFd_3adfeb4e8064a8()) ? null : Double.valueOf(socialParam.getFd_3adfeb4e8064a8()));
		//预估个人部分
		socialInfo.setFd_3adfeb52a4d2e2(CommonConstants.EMPTY_STRING.equals(socialParam.getFd_3adfeb52a4d2e2()) ? null : Double.valueOf(socialParam.getFd_3adfeb52a4d2e2()));
		//实缴单位部分
		socialInfo.setFd_3adfeb52fbe966(CommonConstants.EMPTY_STRING.equals(socialParam.getFd_3adfeb52fbe966()) ? null : Double.valueOf(socialParam.getFd_3adfeb52fbe966()));
		//实缴个人部分
		socialInfo.setFd_3adfeb5366dd82(CommonConstants.EMPTY_STRING.equals(socialParam.getFd_3adfeb5366dd82()) ? null : Double.valueOf(socialParam.getFd_3adfeb5366dd82()));
		//结算状态
		socialInfo.setFd_3add9ea428879a(socialParam.getFd_3add9ea428879a());
		//收款状态
		socialInfo.setFd_3add9eaeed2560("未收");
		//付款状态
		socialInfo.setFd_3add9eed23894a("未付");
		//支出结算状态
		socialInfo.setFd_3add9edfbc6f7e("未结算");
		//单号
		socialInfo.setFd_3adfe95c169c48("GJJ" + LocalDateTimeUtils.formatTime(LocalDateTime.now(),DateUtil.DATE_PATTERN)
				+ "_" + socialInfo.getFd_3b10b38f90d138());
	}

	/**
	 * @Description: 推送ekp时更改日期格式
	 * @Author: huyc
	 **/
	public String dateStringInsert(String month) {
		StringBuilder sb = new StringBuilder(month);
		sb.insert(4, "-");
		return sb.toString();
	}
}
