package com.yifu.cloud.plus.v1.yifu.insurances.vo;

import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.util.List;


/**
 * @author licancan
 * @description 投保列表请求参数
 * @date 2022-07-20 16:14:19
 */
@Data
@Schema(description = "投保列表请求参数")
public class InsuranceListParam extends BaseEntity {

	/**
	 * 项目编码
	 */
	@Schema(description = "项目编码")
	private String deptNo;

	/**
	 * 订单编号
	 */
	@Schema(description = "订单编号")
	private String orderNo;

	/**
	 * 投保状态 1待投保 2投保中 3已投保 4投保退回 5 已减员
	 */
	@Schema(description = "投保状态 1待投保 2投保中 3已投保 4投保退回 5 已减员")
	private Integer buyHandleStatus;

	/**
	 * 投保列表专用字段
	 */
	@Schema(description = "投保状态 集合中只能有这三个状态 1待投保 2投保中 4投保退回")
	private List<Integer> buyHandleStatusList;

	/**
	 * 员工姓名
	 */
	@Schema(description = "员工姓名")
	private String empName;

	/**
	 * 员工身份证号
	 */
	@Schema(description = "员工身份证号")
	private String empIdcardNo;

	/**
	 * 保险公司名称
	 */
	@Schema(description = "保险公司名称")
	private String insuranceCompanyName;

	/**
	 * 险种名称
	 */
	@Schema(description = "险种名称")
	private String insuranceTypeName;

	/**
	 * 项目编码列表
	 */
	@Schema(description = "项目编码列表")
	private List<String> deptNoList;

	/**
	 * 投保类型、购买类型， 1新增、3批增、4替换
	 */
	@Schema(description = " 购买类型(派单类型)， 1新增、3批增、4替换")
	private Integer buyType;

	/**
	 * 派单开始时间
	 */
	@Schema(description = "派单开始时间")
	private String startDate;

	/**
	 * 派单结束时间
	 */
	@Schema(description = "派单结束时间")
	private String endDate;

	/**
	 * 减员状态 1待减员 2减员中3减员退回
	 */
	@Schema(description = "减员状态 1待减员 2减员中3减员退回,4减员成功")
	private Integer reduceHandleStatus;

	/**
	 * 购买标准开始
	 */
	@Schema(description = "购买标准开始")
	private Integer buyStandardMin;

	/**
	 * 购买标准结束
	 */
	@Schema(description = "购买标准结束")
	private Integer buyStandardMax;

	@Schema(description ="客户名称")
	private String unitName;

	@Schema(description ="客户编码")
	private String unitNo;

	/**
	 * 是否有效 0有效 1无效
	 */
	@Schema(description = "是否有效 0有效 1无效")
	private Integer isEffect;

	/**
	 * 是否地市自购0是 1 否
	 */
	@Schema(description = "是否地市自购")
	private String isAdress;

}
