package com.yifu.cloud.plus.v1.yifu.insurances.vo;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.checkerframework.common.value.qual.IntVal;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.time.LocalDate;

/**
 * @author licancan
 * @description 保单对应起止保时间编辑入参
 * @date 2022-12-07 17:39:45
 */
@Data
@Schema(description = "保单对应起止保时间编辑入参")
public class InsurancePolicyListEditParam implements Serializable {
	private static final long serialVersionUID = 9200033608149413253L;
	/**
	 * 主键
	 */
	@Schema(description = "主键")
	@NotBlank(message = "主键不能为空")
	private String id;

	/**
	 * 保单编号
	 */
	@Schema(description = "保单编号")
	@NotBlank(message = "保单编号不能为空")
	private String policyNo;

	/**
	 * 保单开始时间
	 */
	@Schema(description = "保单开始时间")
	@NotNull(message = "保单开始时间不能为空")
	private LocalDate policyStart;

	/**
	 * 保单结束时间
	 */
	@Schema(description = "保单结束时间")
	@NotNull(message = "保单结束时间不能为空")
	private LocalDate policyEnd;

	/**
	 * 保险公司名称
	 */
	@Schema(description = "保险公司名称")
	@NotBlank(message = "保险公司名称不能为空")
	private String insuranceCompanyName;

	/**
	 * 险种名称
	 */
	@Schema(description = "险种名称")
	@NotBlank(message = "险种名称不能为空")
	private String insuranceTypeName;

	/**
	 * 是否启用标识 0启用 1未启用
	 */
	@Schema(description = "是否启用标识 0启用 1未启用")
	@NotNull(message = "启用标识不能为空")
	@IntVal({0,1})
	private Integer enableFlag;
}
