package com.yifu.cloud.plus.v1.yifu.insurances.vo;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;

/**
 * @author licancan
 * @description 保单对应起止保时间列表入参
 * @date 2022-12-07 17:12:27
 */
@Data
@Schema(description = "保单对应起止保时间列表入参")
public class InsurancePolicyListParam implements Serializable {
	private static final long serialVersionUID = 1442112261102562729L;
	/**
	 * 保单编号
	 */
	@Schema(description = "保单编号")
	private String policyNo;

	/**
	 * 保单开始时间
	 */
	@Schema(description = "保单开始时间")
	private String policyStart;

	/**
	 * 保单结束时间
	 */
	@Schema(description = "保单结束时间")
	private String policyEnd;

	/**
	 * 保险公司名称
	 */
	@Schema(description = "保险公司名称")
	private String insuranceCompanyName;

	/**
	 * 险种名称
	 */
	@Schema(description = "险种名称")
	private String insuranceTypeName;

	/**
	 * 是否启用标识 0启用 1未启用
	 */
	@Schema(description = "是否启用标识 0启用 1未启用")
	private Integer enableFlag;
}
