package com.yifu.cloud.plus.v1.yifu.insurances.vo;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * @author zhaji
 * @description TODO
 * @date 2022-08-29 14:47:46
 */
@Data
public class InsuredOrderListVo implements Serializable {
	/**
	 * 主键
	 */
	@Schema(description = "主键")
	private String id;

	/**
	 * 唯一id
	 */
	@Schema(description = "唯一id")
	private String onlyId;

	/**
	 * 投保类型， 1新增、3批增、4替换
	 */
	@Schema(description = " 投保类型， 1新增、3批增、4替换")
	private Integer buyType;

	/**
	 * 员工姓名
	 */
	@Schema(description = "员工姓名")
	private String empName;

	/**
	 * 员工身份证号
	 */
	@Schema(description = "员工身份证号")
	private String empIdcardNo;

	/**
	 * 保险公司名称
	 */
	@Schema(description = "保险公司名称")
	private String insuranceCompanyName;

	/**
	 * 险种名称
	 */
	@Schema(description = "险种名称")
	private String insuranceTypeName;

	/**
	 * 购买标准
	 */
	@Schema(description = "购买标准")
	private String buyStandard;
	/**
	 * 医疗额度
	 */
	@Schema(description = "医疗额度")
	private String medicalQuota;

	/**
	 * 身故或残疾额度
	 */
	@Schema(description = "身故或残疾额度")
	private String dieDisableQuota;

	/**
	 * 创建人姓名
	 */
	@Schema(description = "创建人(派单人)")
	private String createName;

	/**
	 * 创建人id
	 */
	@Schema(description = "创建人id(派单人id)")
	private String createBy;

	/**
	 * 创建人部门名称
	 */
	@Schema(description = "创建人部门名称(派单人)")
	private String createUserDeptName;

	/**
	 * 创建时间
	 */
	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern="yyyy-MM-dd HH:mm:ss")
	@Schema(description = "创建时间")
	@TableField(fill = FieldFill.INSERT)
	private LocalDateTime createTime;

	/**
	 * 投保状态 1待投保 2投保中 3已投保 4投保退回 5 已减员
	 */
	@Schema(description = "投保状态 1待投保 2投保中 3已投保 4投保退回 5 已减员")
	private Integer buyHandleStatus;

	/**
	 * 减员状态 1待减员 2减员中3减员退回
	 */
	@Schema(description = "减员状态 1待减员 2减员中3减员退回,4减员成功")
	private Integer reduceHandleStatus;

	/**
	 * 减员ID
	 */
	@Schema(description = "减员ID")
	private Integer refundId;

}
