package com.yifu.cloud.plus.v1.yifu.insurances.vo;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @author licancan
 * @description EKP2INSURANCES 更新结算请求参数
 * @date 2022-08-01 09:50:33
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@Schema(description = "EKP2INSURANCES 更新结算请求参数")
public class UpdateInsuranceSettleParam implements Serializable {
	private static final long serialVersionUID = 1459385763943903153L;
	/**
	 * 结算信息
	 */
	@Schema(description = "结算信息")
	private List<SettleData> settleData;
	/**
	 * 推送信息
	 */
	@Schema(description = "推送信息")
	private PushData  pushData;


	@Data
	@Builder
	@NoArgsConstructor
	@AllArgsConstructor
	public static class SettleData implements Serializable {
		private static final long serialVersionUID = 4572786452410956413L;
		/**
		 * 结算单号（唯一标识） 生成规则：商险明细id + "_" + 结算id
		 */
		@Schema(description = "结算单号（唯一标识）")
		private String sn;
		/**
		 * 	结算状态
		 */
		@Schema(description = "结算状态")
		private String settleStatus;
	}

	@Data
	@Builder
	@NoArgsConstructor
	@AllArgsConstructor
	public static class PushData implements Serializable {
		private static final long serialVersionUID = 4572786452410956413L;
		/**
		 * 推送时间
		 */
		@Schema(description = "推送时间")
		private LocalDateTime pushTime;
	}

}
