package com.yifu.cloud.plus.v1.job.compont;


import com.yifu.cloud.plus.v1.yifu.common.core.constant.SecurityConstants;
import com.yifu.cloud.plus.v1.yifu.common.dapr.config.DaprMsgProperties;
import com.yifu.cloud.plus.v1.yifu.common.dapr.util.HttpDaprUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.stereotype.Component;

/**
 * @Author fxj
 * @Description 定時任務--定时生成 超时提醒
 * @Date 19:57 2023/5/30
 * @Param
 * @return
**/
@Component(value = "msgTask")
@Slf4j
@EnableConfigurationProperties(DaprMsgProperties.class)
public class MsgTask {

	@Autowired
	private DaprMsgProperties daprMsgProperties;

	/**
	 * @Author fxj
	 * @Description 每29分钟刷新 超时待办提醒
	 * @Date 20:01 2023/5/30
	 * @Param
	 * @return
	**/
	public void createOderOverTimeMsg() {
		log.info("-------------每29分钟刷新 超时待办提醒-定时任务开始------------");
		HttpDaprUtil.invokeMethodPost(daprMsgProperties.getAppUrl(), daprMsgProperties.getAppId(),
				"/msg/inner/updateOverTimeMsg", "", Object.class,
				SecurityConstants.FROM_IN);
		log.info("-------------每1分钟刷新 超时待办提醒定时任务结束------------");

	}
	/**
	 * @Author wzb
	 * @Description 每29分钟刷新 薪资状态变更待支出提醒
	 * @Date 17:23 2023/7/3
	 * @Param
	 * @return
	 **/
	public void statusChangeTimeMsg() {
		log.info("-------------每1分钟刷新 薪资状态变更待支出提醒-定时任务开始------------");
		HttpDaprUtil.invokeMethodPost(daprMsgProperties.getAppUrl(), daprMsgProperties.getAppId(),
				"/msg/inner/statusChangeTimeMsg", "", Object.class,
				SecurityConstants.FROM_IN);
		log.info("-------------每1分钟刷新 薪资状态变更待支出提醒定时任务结束------------");
	}

	/**
	 * @Author fxj
	 * @Description 每5分钟刷新 超时待办提醒
	 * @Date 20:01 2023/5/30
	 * @Param
	 * @return
	 **/
	public void cancelHandledMsg() {
		log.info("-------------每5分钟刷新 更新待办任务-定时任务开始------------");
		HttpDaprUtil.invokeMethodPost(daprMsgProperties.getAppUrl(), daprMsgProperties.getAppId(),
				"/msg/inner/cancelHandledMsg", "", Object.class,
				SecurityConstants.FROM_IN);
		log.info("-------------每5分钟刷新 更新待办任务-定时任务结束------------");

	}
}