package com.yifu.cloud.plus.v1.job.compont;

import com.yifu.cloud.plus.v1.yifu.common.core.constant.SecurityConstants;
import com.yifu.cloud.plus.v1.yifu.common.dapr.config.DaprInsurancesProperties;
import com.yifu.cloud.plus.v1.yifu.common.dapr.util.HttpDaprUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

/**
 * @author licancan
 * @description 商险模块到期定时任务
 * @date 2022-08-03 10:39:14
 */
@Component(value = "updateOverdueTask")
@Slf4j
@EnableConfigurationProperties(DaprInsurancesProperties.class)
public class UpdateOverdueTask {
	@Resource
	private DaprInsurancesProperties daprInsurancesProperties;

	/**
	 * 更新商险到期定时任务
	 *
	 * @author licancan
	 * @param
	 * @return void
	 */
	public void updateOverdueTask() throws Exception {
		log.info("-------------更新商险到期-定时任务开始------------");
		HttpDaprUtil.invokeMethodPost(daprInsurancesProperties.getAppUrl(),daprInsurancesProperties.getAppId(),"/insuranceDetail/inner/updateOverdueByTask","", Void.class, SecurityConstants.FROM_IN);
		log.info("------------更新商险到期-定时任务结束------------");
	}

	/**
	 * 重新更新结算状态同步失败的数据
	 *
	 * @author huyc
	 * @param
	 * @return void
	 */
	public void updateSettleStatus() throws Exception {
		log.info("-------------重新更新结算状态同步失败的数据-定时任务开始------------");
		HttpDaprUtil.invokeMethodPost(daprInsurancesProperties.getAppUrl(),daprInsurancesProperties.getAppId(),"/insuranceDetail/inner/updateSettleStatus","", Void.class, SecurityConstants.FROM_IN);
		log.info("------------重新更新结算状态同步失败的数据-定时任务结束------------");
	}

	/**
	 * 更新商险到期定时任务
	 *
	 * @author licancan
	 * @param
	 * @return void
	 */
	public void pushInsEkp() throws Exception {
		log.info("-------------推送商险待结算数据-定时任务开始------------");
		HttpDaprUtil.invokeMethodPost(daprInsurancesProperties.getAppUrl(),daprInsurancesProperties.getAppId(),"/insuranceDetail/inner/pushActualPremium","", Void.class, SecurityConstants.FROM_IN);
		log.info("------------推送商险待结算数据-定时任务结束------------");
	}

	/**
	 * 每天刷新商险到期提醒信息
	 * @author huych
	 * @param
	 * @return void
	 */
	public void everyDayCreateInsuranceAlert() {
		log.info("-------------每天刷新商险到期提醒信息------------");
		HttpDaprUtil.invokeMethodPost(daprInsurancesProperties.getAppUrl(), daprInsurancesProperties.getAppId(),
				"/insuranceWarn/inner/createInsuranceAlert","", Void.class, SecurityConstants.FROM_IN);
		log.info("-------------每天刷新商险到期提醒信息-定时任务开始------------");
	}

	/**
	 * 每天刷新商险到期提醒信息
	 * @author huych
	 * @param
	 * @return void
	 */
	public void pushWxConfrimMessage() {
		log.info("-------------每天九点推送商险待确认信息------------");
		HttpDaprUtil.invokeMethodPost(daprInsurancesProperties.getAppUrl(), daprInsurancesProperties.getAppId(),
				"/temployeeinsurancepre/inner/pushWxConfrimMessage","", Void.class, SecurityConstants.FROM_IN);
		log.info("-------------每天九点推送商险待确认信息-定时任务开始------------");
	}

	/**
	 * 每天刷新商险到期提醒信息
	 * @author huych
	 * @param
	 * @return void
	 */
	public void pushDisConfrimInsurances() {
		log.info("-------------每天三点二十推送商险待确认信息------------");
		HttpDaprUtil.invokeMethodPost(daprInsurancesProperties.getAppUrl(), daprInsurancesProperties.getAppId(),
				"/temployeeinsurancepre/inner/pushDisConfrimInsurances","", Void.class, SecurityConstants.FROM_IN);
		log.info("-------------每天三点二十推送商险待确认信息-定时任务开始------------");
	}

	/**
	 * @Author fxj
	 * @Description 每天刷新商险待办信息到微信
	 * @Date 20:22 2025/4/23
	**/
	public void everyDaypushInsuranceAlertToWx() {
		log.info("-------------每天刷新商险待办信息到微信-定时任务开始------------");
		HttpDaprUtil.invokeMethodPost(daprInsurancesProperties.getAppUrl(), daprInsurancesProperties.getAppId(),
				"/insuranceWarn/inner/pushInsuranceAlertToWx","", Void.class, SecurityConstants.FROM_IN);
		log.info("-------------每天刷新商险待办信息到微信-定时任务结束------------");
	}
}
