package com.yifu.cloud.plus.v1.job.config;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.quartz.SchedulerFactoryBean;

import javax.sql.DataSource;
import java.util.Properties;

/**
 * @Author fxj
 * @Description 
 * @Date 11:47 2022/6/15
 * @Param 
 * @return 
**/
@Configuration
public class SchedulerBeanFactoryConfig {
    @Bean
    public SchedulerFactoryBean SchedulerFactoryBean(DataSource dataSource) {
        SchedulerFactoryBean factoryBean = new SchedulerFactoryBean();
        factoryBean.setDataSource(dataSource);
        Properties properties = new Properties();
        properties.setProperty("org.quartz.scheduler.instanceName", "Scheduler");
        properties.setProperty("org.quartz.scheduler.instanceId", "AUTO");
        //线程池配置
        properties.setProperty("org.quartz.threadPool.class", "org.quartz.simpl.SimpleThreadPool");
        properties.setProperty("org.quartz.threadPool.threadCount", "20");
        properties.setProperty("org.quartz.threadPool.threadPriority", "5");
        //JobStore 配置
        //properties.setProperty("org.quartz.jobStore.class", "org.quartz.impl.jdbcjobstore.JobStoreTX");
		// spring boot 2.6.X 的定时任务修正
		properties.setProperty("org.quartz.jobStore.class", "org.springframework.scheduling.quartz.LocalDataSourceJobStore");

        //集群配置
        properties.setProperty("org.quartz.jobStore.isClustered", "true");
        properties.setProperty("org.quartz.jobStore.clusterCheckinInterval", "15000");
        properties.setProperty("org.quartz.jobStore.maxMisfiresToHandleAtATime", "1");
        properties.setProperty("org.quartz.jobStore.misfireThreshold", "12000");
        //表前缀
        properties.setProperty("org.quartz.jobStore.tablePrefix", "QRTZ_");
        factoryBean.setQuartzProperties(properties);
        factoryBean.setSchedulerName("Scheduler");
        factoryBean.setStartupDelay(10);
        factoryBean.setApplicationContextSchedulerContextKey("applicationContextSchedulerContextKey");
        factoryBean.setOverwriteExistingJobs(true);
        factoryBean.setAutoStartup(true);
        return factoryBean;
    }


}


