package com.yifu.cloud.plus.v1.job.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.job.entity.SysScheduleJob;
import com.yifu.cloud.plus.v1.job.service.SysScheduleJobService;
import com.yifu.cloud.plus.v1.yifu.common.core.util.Common;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.log.annotation.SysLog;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.util.List;


/**
 * @Author fxj
 * @Description 
 * @Date 15:11 2022/6/15
 * @Param 
 * @return
**/
@RestController
@RequiredArgsConstructor
@RequestMapping("/sysschedulejob")
@Tag(name = "定时任务管理")
public class SysScheduleJobController {

    private final SysScheduleJobService sysScheduleJobService;

    /**
     * 简单分页查询
     *
     * @param page           分页对象
     * @param sysScheduleJob
     * @return
     */
	@Operation(summary = "分页查询", description = "分页查询")
    @GetMapping("/page")
    public R<IPage<List<SysScheduleJob>>> getSysScheduleJobPage(Page page, SysScheduleJob sysScheduleJob) {
        return R.ok(sysScheduleJobService.getSysScheduleJobPage(page, sysScheduleJob));
    }


    /**
     * 通过id查询单条记录
     *
     * @param id
     * @return R
     */
	@Operation(summary = "id查询", description = "id查询")
    @GetMapping("/{id}")
    public R<SysScheduleJob> getById(@PathVariable("id") String id) {
        return new R<>(sysScheduleJobService.getById(id));
    }

    /**
     * 新增记录
     *
     * @param scheduleJob
     * @return R
     */
	@Operation(summary = "新增", description = "新增")
    @PostMapping("/add")
    @PreAuthorize("@pms.hasPermission('sys_schedule_add')")
    public R save(@Valid @RequestBody SysScheduleJob scheduleJob) {
        //数据校验
        if (Common.isEmpty(scheduleJob.getBeanName())) {
            return R.failed("bean名称不能为空");
        }
        if (Common.isEmpty(scheduleJob.getMethodName())) {
            return R.failed("方法名称不能为空");
        }
        if (Common.isEmpty(scheduleJob.getCronExpression())) {
            return R.failed("cron表达式不能为空");
        }
        sysScheduleJobService.saveSysScheduleJob(scheduleJob);
        return R.ok("新增成功");
    }

    /**
     * 修改记录
     *
     * @param sysScheduleJob
     * @return R
     */
	@Operation(summary = "修改", description = "修改")
    @SysLog("修改")
    @PutMapping
    @PreAuthorize("@pms.hasPermission('sys_schedulejob_edit')")
    public R update(@RequestBody SysScheduleJob sysScheduleJob) {
        //数据校验
        if (Common.isEmpty(sysScheduleJob.getBeanName())) {
            return R.failed("bean名称不能为空");
        }
        if (Common.isEmpty(sysScheduleJob.getMethodName())) {
            return R.failed("方法名称不能为空");
        }
        if (Common.isEmpty(sysScheduleJob.getCronExpression())) {
            return R.failed("cron表达式不能为空");
        }
        // 修改
        QueryWrapper<SysScheduleJob> queryWrapper = new QueryWrapper<>();

        queryWrapper.eq("JOB_ID", sysScheduleJob.getJobId());
        SysScheduleJob job = sysScheduleJobService.getOne(queryWrapper);
        job.setBeanName(sysScheduleJob.getBeanName());
        job.setMethodName(sysScheduleJob.getMethodName());
        job.setCronExpression(sysScheduleJob.getCronExpression());
        job.setRemark(sysScheduleJob.getRemark());
        job.setParams(sysScheduleJob.getParams());
        sysScheduleJobService.updateSysScheduleJob(job);
        return R.ok("修改成功");
    }

    /**
     * 通过id删除一条记录
     *
     * @param id
     * @return R
     */
	@Operation(summary = "删除", description = "删除")
    @SysLog("删除")
    @DeleteMapping("/{id}")
    @PreAuthorize("@pms.hasPermission('sys_schedulejob_del')")
    public R removeById(@PathVariable String id) {
        sysScheduleJobService.deleteSysScheduleJob(id);
        return R.ok("删除成功");
    }

    /**
     * @param jobIds
     * @Author: wangan
     * @Date: 2019/8/12
     * @Description: 立即执行
     * @return: com.yifu.cloud.v1.common.core.util.RRemoteThirdServiceFallbackImpl
     **/
    @GetMapping("/run")
//    @PreAuthorize("@pms.hasPermission('sys_schedulejob_run')")
    public R run(@RequestParam("jobIds")String jobIds) {
        sysScheduleJobService.run(new String[]{jobIds});
        return R.ok("执行成功");
    }


    /**
     * @param jobIds
     * @Author: wangan
     * @Date: 2019/8/12
     * @Description: 暂停定时任务
     * @return: com.yifu.cloud.v1.common.core.util.R
     **/
    @GetMapping("/pause")
    @PreAuthorize("@pms.hasPermission('sys_schedulejob_pause')")
    public R pause(@RequestParam("jobIds") String jobIds) {
        sysScheduleJobService.pause(new String[]{jobIds});
        return R.ok("暂停成功");
    }

    /**
     * @param jobIds
     * @Author: wangan
     * @Date: 2019/8/12
     * @Description: 恢复定时任务
     * @return: com.yifu.cloud.v1.common.core.util.R
     **/
    @GetMapping("/resume")
    @PreAuthorize("@pms.hasPermission('sys_schedulejob_resume')")
    public R resume(@RequestParam("jobIds") String jobIds) {
        sysScheduleJobService.resume(new String[]{jobIds});
        return R.ok("恢复成功");
    }

}
