/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.mail.controller;

import com.yifu.cloud.plus.v1.mail.service.MailService;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;


/**
 * @Author fxj
 * @Description 邮件发送服务
 * @Date 17:39 2022/12/1
**/
@RestController
@RequiredArgsConstructor
@RequestMapping("/mail" )
@Tag(name = "邮件发送服务")
public class MailController {

    private final MailService mailService;

    /**
     * 邮件发送服务
     * @return
     */
    @Operation(summary = "分页查询", description = "分页查询")
    @GetMapping("/sendMail" )
    public R getTCheckMobilePage() {
        return R.ok(mailService.sendMail(null));
    }

}
