/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.msg.entity;

import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import java.util.Date;

/**
 * 消息提醒
 *
 * @author huyc
 * @date 2023-07-26 14:19:33
 */
@Data
@TableName("t_message_info")
@EqualsAndHashCode()
@Schema(description = "消息提醒")
public class TMessageInfo {

	/**
	 * ID
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@ExcelProperty("ID")
	@Schema(description = "ID")
	private String id;
	/**
	 * 提交人-表单制作人
	 */
	@ExcelAttribute(name = "提交人-表单制作人", maxLength = 10)
	@Length(max = 10, message = "提交人-表单制作人不能超过10个字符")
	@ExcelProperty("提交人-表单制作人")
	@Schema(description = "提交人-表单制作人")
	private String submitUser;
	/**
	 * 0 待办 1 待阅
	 */
	@ExcelAttribute(name = "0 待办 1 待阅", maxLength = 1)
	@Length(max = 1, message = "0 待办 1 待阅不能超过1个字符")
	@ExcelProperty("0 待办 1 待阅")
	@Schema(description = "0 待办 1 待阅")
	private String alertType;
	/**
	 * 0 已处理 1 未处理
	 */
	@ExcelAttribute(name = "0 已处理 1 未处理", maxLength = 1)
	@Length(max = 1, message = "0 已处理 1 未处理不能超过1个字符")
	@ExcelProperty("0 已处理 1 未处理")
	@Schema(description = "0 已处理 1 未处理")
	private String handlerStatus;
	/**
	 * 处理人-当前提醒人
	 */
	@ExcelAttribute(name = "处理人-当前提醒人", maxLength = 10)
	@Length(max = 10, message = "处理人-当前提醒人不能超过10个字符")
	@ExcelProperty("处理人-当前提醒人")
	@Schema(description = "处理人-当前提醒人")
	private String alertUser;
	/**
	 * 处理人-当前提醒人
	 */
	@Schema(description = "处理人-当前提醒人id")
	private String alertUserId;
	/**
	 * 是否通知企业微信用户 0 是 1 否
	 */
	@ExcelAttribute(name = "是否通知企业微信用户", maxLength = 1)
	@ExcelProperty("是否通知企业微信用户")
	@Schema(description = "是否通知企业微信用户 0 是 1 否")
	private String wxFlag;
	/**
	 * listUrl
	 */
	@ExcelAttribute(name = "listUrl", maxLength = 200)
	@Length(max = 200, message = "listUrl不能超过200个字符")
	@ExcelProperty("listUrl")
	@Schema(description = "listUrl")
	private String listUrl;
	/**
	 * infoUrl
	 */
	@ExcelAttribute(name = "infoUrl", maxLength = 200)
	@Length(max = 200, message = "infoUrl不能超过200个字符")
	@ExcelProperty("infoUrl")
	@Schema(description = "infoUrl")
	private String infoUrl;
	/**
	 * 模块
	 */
	@ExcelAttribute(name = "模块", maxLength = 20)
	@Length(max = 20, message = "模块不能超过20个字符")
	@ExcelProperty("模块")
	@Schema(description = "模块")
	private String modelType;
	/**
	 * 关联id
	 */
	@ExcelAttribute(name = "关联id", maxLength = 32)
	@Length(max = 32, message = "关联id不能超过32个字符")
	@ExcelProperty("关联id")
	@Schema(description = "关联id")
	private String modelId;
	/**
	 * 创建时间
	 */
	@ExcelAttribute(name = "创建时间", isDate = true)
	@ExcelProperty("创建时间")
	@Schema(description = "创建时间")
	private Date createTime;

}
