package com.yifu.cloud.plus.v1.yifu.order.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.springframework.web.multipart.MultipartFile;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * @author licancan
 * @description 订单回复新增vo
 * @date 2022-08-31 08:36:32
 */
@Data
public class OrderReplyAddVO implements Serializable {
	private static final long serialVersionUID = 5043110315841697190L;
	/**
	 * 订单编号
	 */
	@Schema(description = "订单编号")
	private String orderNo;

	/**
	 * 回复内容
	 */
	@Schema(description = "回复内容")
	private String replyContent;

	/**
	 * 创建人姓名（回复人）
	 */
	@Schema(description = "创建人姓名（回复人）")
	private String createName;

	/**
	 * 创建时间（回复时间）
	 */
	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern="yyyy-MM-dd HH:mm:ss")
	@Schema(description = "创建时间（回复时间）")
	private LocalDateTime createTime;

	/**
	 * 附件
	 */
	@Schema(description = "附件")
	private MultipartFile[] file;
}
