package com.yifu.cloud.plus.v1.yifu.order.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.yifu.cloud.plus.v1.yifu.order.entity.TOrderEnclosure;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @author licancan
 * @description 订单回复列表vo
 * @date 2022-08-29 17:07:50
 */
@Data
@Schema(description = "订单回复列表vo")
public class OrderReplyListVO implements Serializable {
	private static final long serialVersionUID = -1376876766552447670L;

	/**
	 * 主键
	 */
	@Schema(description = "主键")
	private String id;

	/**
	 * 订单编号
	 */
	@Schema(description = "订单编号")
	private String orderNo;

	/**
	 * 创建人姓名（回复人）
	 */
	@Schema(description = "创建人姓名（回复人）")
	private String createName;

	/**
	 * 创建时间（回复时间）
	 */
	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern="yyyy-MM-dd HH:mm:ss")
	@Schema(description = "创建时间（回复时间）")
	private LocalDateTime createTime;

	/**
	 * 回复内容
	 */
	@Schema(description = "回复内容")
	private String replyContent;

	/**
	 * 回复附件
	 */
	@Schema(description = "回复附件")
	private List<TOrderEnclosure> orderReplyEnclosure;
}
