/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.permission.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.yifu.cloud.plus.v1.yifu.permission.entity.EkpQiwiWorkovertime;
import com.yifu.cloud.plus.v1.yifu.permission.entity.EkpQiwiZhaoPin;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * E人事加班申请
 *
 * @author chenyuxi
 * @since 1.9.6
 */
@Mapper
public interface EkpQiweiWorkovertimeMapper extends BaseMapper<EkpQiwiWorkovertime> {

	/**
	 * 已被拉取的90天内的数据Map
	 * 获取全部的列表，用来： 拉取企E人事加班数据时，不覆盖数据
	 * @return java.util.Map<java.lang.String, java.lang.String>
	 **/
	List<EkpQiwiWorkovertime> getWorkovertimeMapByTimeRange(@Param("queryStartTime") String queryStartTime,@Param("queryEndTime") String queryEndTime);
}
