package com.yifu.cloud.plus.v1.permission.mapper;/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.admin.api.vo.HcmRoleInfoVo;
import com.yifu.cloud.plus.v1.yifu.permission.entity.SysRoleInfo;
import com.yifu.cloud.plus.v1.yifu.permission.vo.SysRoleInfoSearchVo;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 新权限-角色表
 *
 * @author hgw
 * @date 2023-08-29 14:49:40
 */
@Mapper
public interface SysRoleInfoMapper extends BaseMapper<SysRoleInfo> {
	/**
	 * 新权限-角色表简单分页查询
	 *
	 * @param sysRoleInfo 新权限-角色表
	 * @return
	 */
	IPage<SysRoleInfo> getSysRoleInfoPage(Page<SysRoleInfo> page, @Param("sysRoleInfo") SysRoleInfoSearchVo sysRoleInfo);

	/**
	 * @Description: 给前端使用：根据角色id组合获取角色权限
	 * @Author: hgw
	 * @Date: 2023/9/8 9:21
	 * @return: java.util.List<java.lang.String>
	 **/
	List<String> getRoleDataAuthByRoleId(@Param("roleIdList") List<String> roleIdList);

	/**
	 * @param loginName
	 * @Description: 获取账号的所有权限
	 * @Author: hgw
	 * @Date: 2023/9/8 9:22
	 * @return: java.util.List<java.lang.String>
	 **/
	List<String> getAllRoleDataAuthByUserId(@Param("loginName") String loginName);

	/**
	 * @param roleName
	 * @param roleId
	 * @Description: 查找名称是否存在
	 * @Author: hgw
	 * @Date: 2023/9/8 9:22
	 * @return: int
	 **/
	int checkExistenceRole(@Param("roleName") String roleName, @Param("roleId") String roleId);


	/**
	 * hcm查询角色信息
	 * @return
	 */
	List<HcmRoleInfoVo> getRoleList();
}
