package com.yifu.cloud.plus.v1.permission.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.permission.entity.SysUserPermission;
import com.yifu.cloud.plus.v1.yifu.permission.vo.*;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 新权限-用户权限表
 *
 * @author hyc
 * @date 2023-08-29 14:49:40
 */
@Mapper
public interface SysUserPermissionMapper extends BaseMapper<SysUserPermission> {
	/**
	 * 新权限-用户权限表简单分页查询
	 *
	 * @param sysUserPermission 新权限-用户权限表
	 * @return
	 */
	IPage<SysUserPermission> getSysUserPermissionPage(Page<SysUserPermission> page, @Param("sysUserPermission") SysUserPermissionSearchVo sysUserPermission);

	/**
	 * 导出查询数量
	 *
	 * @param sysUserPermission 新权限-用户权限表
	 * @return
	 */
	long userSelectCount(@Param("sysUserPermission") SysUserPermissionSearchVo sysUserPermission);

	/**
	 * 查询导出数据
	 *
	 * @param sysUserPermission 新权限-用户权限表
	 * @return
	 */
	List<SysUserPermissionExportVo> userSelectList(@Param("sysUserPermission") SysUserPermissionSearchVo sysUserPermission);

	/**
	 * 根据名称或者编码查询数据
	 * 单位权限
	 * @param name 名称
	 * @return
	 */
	IPage<SysUserDeptVo> selectUnitVO(Page<SysUserDeptVo> page, @Param("name") String name);

	/**
	 * 根据名称或者编码查询数据
	 * 合同权限
	 * @param name 名称
	 * @return
	 */
	IPage<SysUserDeptVo> selectContractVO(Page<SysUserDeptVo> page, @Param("name") String name);

	/**
	 * 根据名称或者编码查询数据
	 * 合同权限
	 * @param name 名称
	 * @return
	 */
	IPage<SysUserDeptVo> selectContractSimpleVO(Page<SysUserDeptVo> page, @Param("loginName") String loginName, @Param("name") String name, @Param("type") String type);

	/**
	 * 根据名称或者编码查询数据
	 * 项目权限
	 * @param name 名称
	 * @return
	 */
	IPage<SysUserDeptVo> selectSettleVO(Page<SysUserDeptVo> page, @Param("name") String name);

	/**
	 * 根据名部门编码查询id
	 * 部门权限
	 * @param code 编码
	 * @return
	 */
	String selectSettleByCode(@Param("code") String code);

	/**
	 * 根据名称或者编码查询数据
	 * 商机权限
	 * @param name 名称
	 * @return
	 */
	IPage<SysUserDeptVo> selectBusinessVO(Page<SysUserDeptVo> page, @Param("name") String name);

	/**
	 * 根据名称或者编码查询数据
	 * 报价单权限
	 * @param name 名称
	 * @return
	 */
	IPage<SysUserDeptVo> selectQuotationVO(Page<SysUserDeptVo> page, @Param("name") String name);

	/**
	 * 根据名称或者编码查询数据
	 * 部门&&收入归属权限
	 * @param name 名称
	 * @return
	 */
	IPage<SysUserDeptVo> selectDeptVO(Page<SysUserDeptVo> page, @Param("name") String name);

	/**
	 * 根据名称或者编码查询数据
	 * 二级指标归属权限
	 * @param name 名称
	 * @return
	 */
	IPage<SysUserDeptVo> selectTwoGsVO(Page<SysUserDeptVo> page, @Param("name") String name);

	/**
	 * @Description: 查找税务主体分页
	 * @Author: hgw
	 * @Date: 2024/1/10 16:27
	 * @return: com.baomidou.mybatisplus.core.metadata.IPage<com.yifu.cloud.plus.v1.yifu.permission.vo.SysUserDeptVo>
	 **/
	IPage<SysUserDeptVo> selectTaxVO(Page<SysUserDeptVo> page, @Param("name") String name);

	/**
	 * 根据类型查询字典值
	 *
	 * @param type 类型
	 * @return
	 */
	List<SysDictVo> selectDictByType(@Param("type") String type);

	/**
	 * 根据类型查询字典值
	 *
	 * @param type 类型
	 * @return
	 */
	List<SysDictVo> selectDictByTypeOne(@Param("type") String type,@Param("userId") String userId);

	/**
	 * 根据类型和名称判断字典值是否存在
	 *
	 * @param type 类型
	 * @return
	 */
	Integer selectDictByName(@Param("name") String name,@Param("type") String type);

	/**
	 * 根据名称或者编码查询数据
	 * 单位权限
	 * @param name 名称
	 * @return
	 */
	Integer selectUnitCount(@Param("name") String name);

	/**
	 * 根据名称或者编码查询数据
	 * 合同权限
	 * @param name 名称
	 * @return
	 */
	Integer selectContractCount(@Param("name") String name);

	/**
	 * 根据名称或者编码查询数据
	 * 项目权限
	 * @param name 名称
	 * @return
	 */
	Integer selectSettleCount(@Param("name") String name);

	/**
	 * 根据名称或者编码查询数据
	 * 商机权限
	 * @param name 名称
	 * @return
	 */
	Integer selectBusinessCount(@Param("name") String name);

	/**
	 * 根据名称或者编码查询数据
	 * 报价单权限
	 * @param name 名称
	 * @return
	 */
	Integer selectQuotationCount(@Param("name") String name);

	/**
	 * 根据名称或者编码查询数据
	 * 部门&&收入归属权限
	 * @param name 名称
	 * @return
	 */
	Integer selectDeptCount(@Param("name") String name);

	/**
	 * 根据名称或者编码查询数据
	 * 部门&&收入归属权限
	 * @param name 名称
	 * @return
	 */
	Integer selectTwoGsCount(@Param("name") String name);

	/**
	 * @Description: 查询税务主体是否存在
	 * @Author: hgw
	 * @Date: 2024/1/10 16:22
	 * @return: java.lang.Integer
	 **/
	Integer selectTaxCount(@Param("name") String name);

	/**
	 * @param userId
	 * @Description: 查找当前用户的所有权限
	 * @Author: hgw
	 * @Date: 2023/9/11 11:44
	 * @return: java.util.List<com.yifu.cloud.plus.v1.yifu.permission.entity.SysUserPermission>
	 **/
	List<SysUserPermission> getUserPermissionByUserId(@Param("userId") String userId);

	List<SysUserPermission> getUserPermissionByAutoCreateKH(@Param("fdId") String fdId);
	List<SysUserPermission> getUserPermissionByAutoCreateSJ(@Param("fdId") String fdId);
	List<SysUserPermission> getUserPermissionByAutoCreateBJD(@Param("fdId") String fdId);
	List<SysUserPermission> getUserPermissionByAutoCreateHT(@Param("fdId") String fdId);
	List<SysUserPermission> getUserPermissionByAutoCreateXM(@Param("fdId") String fdId);
	List<SysUserPermission> getUserPermissionByAutoCreateHTBG(@Param("fdId") String fdId);
	List<SysUserPermission> getUserPermissionByAutoCreateXMBG(@Param("fdId") String fdId);
	String selectCodeByFdId(@Param("fdId") String fdId);

	void deleteUserPermissionByIdAndType(@Param("code") String code, @Param("permissionType") String permissionType);

	Integer selectDivitionCount(@Param("name")String name);

	Integer selectDivitionLineCount(@Param("name")String name);
	//变更后项目负责人
	List<SysUserPermission> getUserPermissionByAutoCreateXMBG1(String fdId);
	//变更前项目负责人
	List<SysUserPermission> getUserPermissionByAutoCreateXMBG2(String fdId);
	//变更后项目团队
	List<SysUserPermission> getUserPermissionByAutoCreateXMBG3(String fdId);
	//变更前项目团队
	List<SysUserPermission> getUserPermissionByAutoCreateXMBG4(String fdId);
}

