package com.yifu.cloud.plus.v1.permission.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.permission.entity.EkpQiwiChuchai;
import com.yifu.cloud.plus.v1.yifu.permission.entity.EkpQiwiWorkovertime;
import com.yifu.cloud.plus.v1.yifu.permission.entity.EkpQiwiZhaoPin;

import java.util.List;

/**
 * 成本支出表
 *
 * @author hgw
 * @date 2024-4-15 17:16:50
 */
public interface QiWeiService extends IService<EkpQiwiChuchai> {

	/**
	 * @param startTime
	 * @param endTime
	 * @param type 1：企业微信；2：HCM的E人事
	 * @Description: 获取微信信息
	 * @Author: hgw
	 * @Date: 2021-7-28 17:46:01
	 * @return: com.yifu.cloud.v1.common.core.util.R<java.util.List < com.yifu.cloud.v1.hrms.api.entity.TStatisticsProjectReimburse>>
	 **/
	R<List<EkpQiwiChuchai>> getQiWeiChuChaiAndSave(String startTime, String endTime, int type);


	/**
	 * @Description: 获取企业微信审批里的【招聘平台采购/调配】
	 * @Author: hgw
	 * @Date: 2024/8/22 11:18
	 * @return: com.yifu.cloud.plus.v1.yifu.common.core.util.R<java.util.List < com.yifu.cloud.plus.v1.yifu.permission.entity.EkpQiwiChuchai>>
	 **/
	R<List<EkpQiwiZhaoPin>> getQiWeiZhaoPinAndSave(String startTime, String endTime);

	/**
	 * 获取HCM审批通过的加班数据并存储到EKP
	 * @param startDay 开始日期
	 * @param endDay 结束日期
	 * @author chenyuxi
	 * @since  1.9.6
	 * @date   2025-02-06
	 * @return R<List<EkpQiwiChuchai>>
	 **/
	R<List<EkpQiwiWorkovertime>> getHcmWorkOvertimeAndSave(String startDay, String endDay);


}
