package com.yifu.cloud.plus.v1.yifu.process.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.time.LocalDateTime;


/**
 * 定时流程节点配置
 *
 * @author hgw
 * @date 2020-07-16 17:48:52
 */
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("t_delay_node_config")
@Schema(description = "定时流程节点配置")
public class TDelayNodeConfig extends Model<TDelayNodeConfig> {
     private static final long serialVersionUID = 1L;

     @TableId(type = IdType.ASSIGN_ID)
     @Schema(description = "主键")
     private String id;

     @NotBlank(message = "定时方式（0延时指定的分钟后执行/1指定一个时间点执行）不能为空")
     @Length(max = 1, message = "定时方式（0延时指定的分钟后执行/1指定一个时间点执行）不能超过1个字符")
     @Schema(description = "定时方式（0延时指定的分钟后执行/1指定一个时间点执行）")
     private String delayType;

     @Schema(description = "分钟")
     private Integer minutes;

     @Schema(description = "时间")
     private LocalDateTime time;

     @NotBlank(message = "流程节点ID不能为空")
     @Length(max = 255, message = "流程节点ID不能超过255个字符")
     @Schema(description = "流程节点ID")
     private String nodeId;
}
